/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.v2.cli.tools;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import dvi.DviFontSpec;
import dvi.DviUnit;
import dvi.api.DviContext;
import dvi.ctx.DefaultDviContext;
import dvi.font.LogicalFont;
import dvi.gui.swing.ViewSpec;
import dvi.util.Benchmark;
import dvi.util.DviUtils;
import dvi.v2.csv.StringCsvData;
public class ResolveFontsInCSV {
  private static final Logger LOGGER = Logger.getLogger(ResolveFontsInCSV.class.getName());
  
  public static void printUsage(PrintStream out)
  {
    out.println(ScanFonts.class.getName() + " - Resolve fonts listed in the specified CSV file.");
    out.println("Command line arguments: none");
    out.println("Font specifications are read from the fontspecs.csv file in the current directory.");
  }
  
  public static void main(String[] args)
  throws Exception
  {
    if (args.length != 0) {
      printUsage(System.out);
      System.out.println("error: No inputs");
    } else {
      StringCsvData csv = new StringCsvData();
      final DviContext ctx = new DefaultDviContext();
      final ViewSpec viewSpec = new ViewSpec(ctx);
      File file = new File("fontspecs.csv");
      csv.readFromFile(file);
      Benchmark bm = new Benchmark();
      bm.begin("Loading PK fonts");
      for (int i=0; i<csv.getRowCount(); i++) {
        bm.addSample();
        try {
          Map<String, String> row = csv.getRow(i);
          int cs = Integer.parseInt(row.get("cs"));
          int ss = Integer.parseInt(row.get("ss"));
          int ds = Integer.parseInt(row.get("ds"));
          int al = Integer.parseInt(row.get("al"));
          int nl = Integer.parseInt(row.get("nl"));
          String name = row.get("name");
          DviFontSpec fs = DviFontSpec.getInstance(cs, ss, ds, al, nl, name);
          LogicalFont logicalFont = LogicalFont.getInstance(fs, DviUnit.DEFAULT, viewSpec.getResolution());
          URL url = ctx.getDviResource(logicalFont.fontSpec().fontName().name() + ".2400pk");
          System.out.println(url);
          //DviFont font = ctx.findDviFont(logicalFont);
//          System.out.println("[" + i + "] " + font + " <= " + fs);
        } catch (Exception e) {
          DviUtils.logStackTrace(LOGGER, Level.WARNING, e);
        }
        System.out.println(bm.format());
      }
      bm.end();
      System.out.println(bm.format());
    }
  }
}
