package test.dvi.v2.csv;
import java.io.File;
import java.io.IOException;

import junit.framework.Assert;

import org.junit.Test;

import dvi.v2.csv.CsvException;
import dvi.v2.csv.StringCsvData;


/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

public class StringCsvDataTest {
//  private static final Logger LOGGER = Logger.getLogger(StringCsvDataTest.class
//      .getName());
  @Test
  public void testStringCsvData() throws IOException, CsvException
  {
    File tmpFile = File.createTempFile("test", "tmp");
    tmpFile.deleteOnExit();
    try {
      StringCsvData orig = new StringCsvData();
      orig.beginLine();
      orig.put("key1", "value1");
      orig.put("key2", "value\n2");
      orig.put("key3", "value\t3");
      orig.put("key4", "value\r4");
      orig.endLine();
      orig.beginLine();
      orig.put("key3", "value 3 second");
      orig.endLine();
      orig.writeToFile(tmpFile);
      
      StringCsvData r1 = new StringCsvData();
      r1.readFromFile(tmpFile);
      Assert.assertEquals(4, orig.getColumnCount());
      Assert.assertEquals(orig.getColumnCount(), r1.getColumnCount());
      Assert.assertEquals(2, orig.getRowCount());
      Assert.assertEquals(orig.getRowCount(), r1.getRowCount());
      Assert.assertTrue("Objects are not equal", r1.equals(orig));
      Assert.assertTrue("Objects are not equal", orig.equals(r1));
    } finally {
      tmpFile.delete();
    }
  }
}
