﻿// In the original BSD license, both occurrences of the phrase "COPYRIGHT HOLDERS AND CONTRIBUTORS"
// in the disclaimer read "REGENTS AND CONTRIBUTORS".
//
// Here is the license template:
//
// Copyright (c) 2010, Masanori Usami
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are permitted provided
// that the following conditions are met:
//
//  * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
//    in the documentation and/or other materials provided with the distribution.
//  * Neither the name of the <ORGANIZATION> nor the names of its contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
// BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
// OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;

namespace EAAddinDSM
{

    /// <summary>
    /// UMLモデルのDSMを取得するためのクラス
    /// Enterprise Architect Add-In用
    /// </summary>
    public class DependencyStructureMatrix
    {
        private const string parentMenuNames_ = "-UML DSM";
        private const string menuDiagramClassDSM_ = "ダイアグラムDSM表示（クラス図）";
        private const string menuPackageClassDSM_ = "パッケージDSM表示（クラス図）";
        private const string menuDiagramObjectDSM_ = "ダイアグラムDSM表示（オブジェクト図）";
        private const string menuPackageObjectDSM_ = "パッケージDSM表示（オブジェクト図）";
        private string[] childMenuMenu_ = { menuDiagramClassDSM_, menuPackageClassDSM_, menuDiagramObjectDSM_, menuPackageObjectDSM_ };
        private string[] childMenuDiagram_ = { menuDiagramClassDSM_, menuDiagramObjectDSM_ };
        private string[] childMenuTree_ = { menuPackageClassDSM_, menuPackageObjectDSM_ };
        private string elementType_ = "Class";

        /// <summary>
        /// コンストラクタ
        /// helper関数の準備をする
        /// </summary>
        public DependencyStructureMatrix()
        {
        }

        /// <summary>
        /// メニューの設定
        /// </summary>
        /// <param name="repository">EAリポジトリオブジェクト</param>
        /// <param name="menuLocation">メニューが呼ばれた位置 "TreeView"/"MainMenu"/"Diagram"</param>
        /// <param name="menuName">親メニューの文字列</param>
        /// <returns></returns>
        public object EA_GetMenuItems(EA.Repository repository, string menuLocation, string menuName)
        {
            switch (menuName)
            {
                case "":
                    return parentMenuNames_;
                case parentMenuNames_:
                    switch (menuLocation)
                    {
                        case "MainMenu":
                            return childMenuMenu_;
                        case "Diagram":     // 子メニュー ダイアグラムから選択された場合
                            return childMenuDiagram_;
                        case "TreeView":    // 子メニュー ツリービューから呼ばれた場合
                            return childMenuTree_;
                    }
                    return null;
                default:
                    return null;
            }
        }

        /// <summary>
        /// メニュークリック時の処理
        /// </summary>
        /// <param name="repository">EAリポジトリオブジェクト</param>
        /// <param name="menuLocation">メニューが呼ばれた位置 "TreeView"/"MainMenu"/"Diagram"</param>
        /// <param name="menuName">親メニューの文字列</param>
        /// <param name="itemName">選択されたメニューの文字列</param>
        public void EA_MenuClick(EA.Repository repository, string menuLocation, string menuName, string itemName)
        {
            EA.Diagram diagram = repository.GetCurrentDiagram();
            EA.Package package = repository.GetTreeSelectedPackage();
            DSMDialog dialog = new DSMDialog();
            if ((itemName == menuDiagramClassDSM_ || itemName == menuDiagramObjectDSM_) && (diagram == null))
            {
                MessageBox.Show("ダイアグラムが開かれていません");
                return;
            }
            if ((itemName == menuPackageClassDSM_ || itemName == menuPackageObjectDSM_) && (package == null))
            {
                MessageBox.Show("パッケージが選択されていません");
                return;
            }
            switch (itemName)
            {
                case menuDiagramClassDSM_:
                    elementType_ = "Class";
                    dialog.initialize(repository, diagram, elementType_);
                    break;
                case menuPackageClassDSM_:
                    elementType_ = "Class";
                    dialog.initialize(repository, package, elementType_);
                    break;
                case menuDiagramObjectDSM_:
                    elementType_ = "Object";
                    dialog.initialize(repository, diagram, elementType_);
                    break;
                case menuPackageObjectDSM_:
                    elementType_ = "Object";
                    dialog.initialize(repository, package, elementType_);
                    break;
                default:
                    break;
            }
            dialog.ShowDialog();
        }
    }
}
