/*
 Copyright (C) 2010 Kuri-Applications

 Convert.h - declarations of functions for convertion between charsets
 */

#ifndef __CONVERT_H__
#define __CONVERT_H__

typedef const BYTE FAR* LPCBYTE;

extern "C" DWORD __stdcall UnicodeToUTF8(LPCWSTR lpszUnicode, DWORD dwLength, LPBYTE lpBuffer, DWORD dwBufferLength);
extern "C" DWORD __stdcall UnicodeToUTF8File(LPCWSTR lpszUnicode, DWORD dwLength, HANDLE hFile, BOOL* pbResult = NULL);
extern "C" DWORD __stdcall UnicodeFileToUTF8(HANDLE hFile, LPBYTE lpBuffer, DWORD dwBufferLength);
extern "C" bool __stdcall IsUTF8Data(LPCBYTE lpszUTF8, DWORD dwByteLength);
// 0: not enough length, -1: invalid data
extern "C" DWORD __stdcall GetUTF8Length(LPCBYTE lpszUTF8, DWORD dwMaxByteLength);
extern "C" bool __stdcall IsUTF8File(HANDLE hFile);
extern "C" DWORD __stdcall UTF8ToUnicode(LPCBYTE lpszUTF8, DWORD dwByteLength, LPWSTR lpBuffer, DWORD dwBufferLength);
// bEndian: 0x00: Big, 0x01: Little(8bit*2*2), 0x02: Little(16bit*2), 0x03: Little(8bit*4)
//   0x11223344 ɂ
//     bEndian == 0x00: 11 22 33 44 (0x11 22 33 44 ̂܂)  ʓI Big-endian
//             == 0x01: 22 11 44 33 ((0x11 22)(33 44)  ( ) o[X)
//             == 0x02: 33 44 11 22 (0x1122 3344 o[X)
//             == 0x03: 44 33 22 11 (0x11 22 33 44 o[X)  ʓI Little-endian
enum EndianConstants
{
	endBigEndian = 0,
	endLittle822Endian,
	endLittle162Endian,
	endLittle84Endian,
	endLittleEndian = endLittle84Endian
};
extern "C" DWORD __stdcall UTF8ToUnicodeFile(LPCBYTE lpszUTF8, DWORD dwByteLength, HANDLE hFile, BYTE bEndian);
extern "C" DWORD __stdcall UTF8FileToUnicode(HANDLE hFile, LPWSTR lpBuffer, DWORD dwBufferLength);

extern "C" bool __stdcall IsEUCChar(BYTE ch1, BYTE ch2);
extern "C" bool __stdcall IsEUCFirstChar(BYTE ch1);
extern "C" bool __stdcall IsShiftJISFirstChar(BYTE ch1);

extern "C" bool __stdcall EUCToShiftJISString(LPSTR lpBuffer, DWORD dwBufferLength);
extern "C" bool __stdcall ShiftJISToEUCString(LPSTR lpBuffer, DWORD dwBufferLength);

extern "C" DWORD __stdcall EUCFileToShiftJIS(HANDLE hFile, LPSTR lpBuffer, DWORD dwBufferLength);
extern "C" DWORD __stdcall ShiftJISToEUCFile(LPCSTR lpBuffer, DWORD dwBufferLength, HANDLE hFile, BOOL* pbResult = NULL);

extern "C" inline bool __stdcall IsEUCChar(BYTE ch1, BYTE ch2)
{
	return (ch1 == 0x8E && ch2 >= 0xA0 && ch2 <= 0xDF) ||
		(ch1 >= 0xA1 && ch1 <= 0xFE && ch2 >= 0xA1 && ch2 <= 0xFE);
}

extern "C" inline bool __stdcall IsEUCFirstChar(BYTE ch1)
{
	return (ch1 == 0x8E) || (ch1 >= 0xA1 && ch1 <= 0xFE);
}

extern "C" inline bool __stdcall IsShiftJISFirstChar(BYTE ch1)
{
	//return (ch1 >= 0x81 && ch1 <= 0x9F) || (ch1 >= 0xE0 && ch1 <= 0xFC) ||
	//	(ch1 >= 0xA0 && ch1 <= 0xDF);
	return (ch1 >= 0x81 && ch1 <= 0xFC);
}

#endif // __CONVERT_H__
