﻿#include "AnalyzerWindow.h"
#include "ui_AnalyzerWindow.h"

#include "../delegate/FileopenDelegate.h"
#include "../delegate/ComboboxDelegate.h"

using namespace stand::analyzer;

AnalyzerWindow::AnalyzerWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::AnalyzerWindow)
{
    ui->setupUi(this);

    QStringList sl, types;
    sl << "Sequence File" << "Sequence type" << "Volume Envelope" << "Pitch Contour";
    types << "Vsq File" << "Vsq Meta Text" << "Raw Sequence";

    ui->FileTable->setHorizontalHeaderLabels(sl);

    _seq = new stand::delegate::FileopenDelegate(tr("Select Sequence"), "", tr("Sequence File (*.*)"), this);
    _type = new stand::delegate::ComboboxDelegate(types, this);
    _vol = new stand::delegate::FileopenDelegate(tr("Select volume envelope."), "", tr("Envelope File (*.env)"), this);
    _pit = new stand::delegate::FileopenDelegate(tr("Select pitch envelope."), "", tr("Envelope File (*.env)"), this);
    ui->FileTable->setItemDelegateForColumn(0, _seq);
    ui->FileTable->setItemDelegateForColumn(1, _type);
    ui->FileTable->setItemDelegateForColumn(2, _vol);
    ui->FileTable->setItemDelegateForColumn(3, _pit);
}

AnalyzerWindow::~AnalyzerWindow()
{
    delete ui;
    delete _seq;
    delete _vol;
    delete _pit;
    delete _type;
}
