﻿#include "FileopenDelegate.h"

#include <QFileDialog>

using namespace stand::delegate;

FileopenDelegate::FileopenDelegate(const QString &caption, const QString &dir, const QString &filter, QObject *parent) :
    QItemDelegate(parent)
{
    _caption = caption;
    _dir = dir;
    _filter = filter;
}

QWidget *FileopenDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    QFileDialog *e = new QFileDialog(parent, _caption, _dir, _filter);
    e->setAcceptMode(QFileDialog::AcceptOpen);
    e->setFileMode(QFileDialog::ExistingFile);
    e->hide();
    return e;
}

void FileopenDelegate::setEditorData(QWidget *editor, const QModelIndex &index) const
{
    QString val = index.model()->data(index, Qt::EditRole).toString();
    QDir dir(val);
    QFileDialog *e = static_cast<QFileDialog *>(editor);
    e->setDirectory(dir);
}

void FileopenDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const
{
    QFileDialog *e = static_cast<QFileDialog *>(editor);

    QStringList files = e->selectedFiles();
    QString val;
    if(!files.empty())
    {
        val = files.at(0);
    }

    model->setData(index, val, Qt::EditRole);
}

void FileopenDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
}
