#ifndef LYRICCHANGECOMMAND_H
#define LYRICCHANGECOMMAND_H

#include <QUndoCommand>
#include <QModelIndex>
#include <QAbstractItemModel>

namespace stand
{
namespace model
{
class TreeItemModel;
}
namespace delegate
{
namespace command
{

class LyricChangeCommand : public QUndoCommand
{
public:
    explicit LyricChangeCommand(const QString &lyric, const QModelIndex &index, QAbstractItemModel *model, QUndoCommand *child = 0);

    virtual void undo();
    virtual void redo();

    inline void setChild(QUndoCommand *child)
    {
        _child = child;
    }

private:
    QString _backup;
    QString _lyric;
    QModelIndex _index;
    QAbstractItemModel *_model;

    QUndoCommand *_child;
};

}
}
}

#endif // LYRICCHANGECOMMAND_H
