#ifndef ECHOES_ALIGNMENT_H
#define ECHOES_ALIGNMENT_H

#include <stdio.h>

namespace stand
{
namespace utility
{
namespace envelope
{
class Envelope;
}
}
namespace echoes
{

class Alignment
{
public:
    /*!
     *  @brief コンストラクタ．与えられた引数からパラメータを初期化します．
     *  @attention 多分引数は変わる
     */
    explicit Alignment(int noteTarget = 0, int noteDiff = 0, int preLength = 0, int postLength = 0);
    Alignment(const Alignment &b);
    virtual ~Alignment();

    void write(FILE *fp) const;
    bool read(FILE *fp);

    inline int noteDiff() const
    {
        return _params[_ParamNoteDiff];
    }
    inline void setNoteDiff(int noteDiff)
    {
        _params[_ParamNoteDiff] = noteDiff;
    }

    inline int noteTarget() const
    {
        return _params[_ParamNoteTarget];
    }
    inline void setNoteTarget(int noteTarget)
    {
        _params[_ParamNoteTarget] = noteTarget;
    }

    inline int preLength() const
    {
        return _params[_ParamPreLength];
    }
    inline void setPreLength(int preLength)
    {
        _params[_ParamPreLength] = preLength;
    }

    inline int postLength() const
    {
        return _params[_ParamPostLength];
    }
    inline void setPostLength(int postLength)
    {
        _params[_ParamPostLength] = postLength;
    }

    Alignment &operator = (const Alignment &b);

    bool operator ==(const Alignment &b) const;
    bool operator !=(const Alignment &b) const;
    bool operator < (const Alignment &b) const;
    bool operator <=(const Alignment &b) const;
    bool operator > (const Alignment &b) const;
    bool operator >=(const Alignment &b) const;

private:
    const static int _ParamNum = 4;
    int _params[_ParamNum];

    enum
    {
        _ParamPreLength,
        _ParamPostLength,
        _ParamNoteDiff,
        _ParamNoteTarget,
    };
};

}
}

#endif // ECHOES_ALIGNMENT_H
