#ifndef ECHOES_ANALYZER_H
#define ECHOES_ANALYZER_H

#include <QList>
#include <QPair>

namespace stand
{
namespace model
{
class SequenceModel;
class TreeItem;
class ControlItem;
}
namespace echoes
{

class Alignment;
class Data;

/*!
 *  @brief ECHOES の分析を行うクラス．
 */
class Analyzer
{
public:
    struct Item;
    /*!
     *  @brief 分析を行うメソッド．
     *         このメソッドは Dictionary クラスから呼び出され，
     *         Alignment, Data のペアのリストを生成します．
     *  @param[out] dst         分析されたデータ．
     *  @return 分析の成否．
     */
    virtual bool analyze(QList<QPair<Alignment, Data> > &dst, const Item &item);

    /*!
     *  @brief アライメントを計算します．
     *  @param[out] dst 計算結果が格納されます．
     *  @param[in] events イベントトラック．
     *  @param[in] id イベントトラック中の id ．
     */
    static void getAlignment(Alignment &dst, stand::model::TreeItem *events, int id, int step);

    static void getData(Data &dst, stand::model::ControlItem * f0, stand::model::ControlItem *volume, int tick, int step);


    struct Item
    {
        const stand::model::SequenceModel *sequence;
        int trackId;
        int f0ControlId;
        int volumeControlId;
        int step;
    };
};

}
}


#endif // ECHOES ANALYZER_H
