#include "Echoes.h"

#include "EventItem.h"
#include "ControlItem.h"

#include "Utility.h"

#include "Alignment.h"
#include "Data.h"
#include "Dictionary.h"

#include "../../configure.h"

using namespace stand::echoes;
using namespace stand::model;

bool Echoes::exec(const Contours &contours) const
{
    for(int i = 0; i < contours.events.size(); i++)
    {
        EventItem *prev = NULL, *item = contours.events[i];
        if(i)
        {
            prev = contours.events[i-1];
        }
        Alignment alignment(item->note(), 0, 0, item->length());
        if(prev && prev->tick() + prev->length() <= item->tick() - stand::sequence::DefaultTicksPerBeat / 8)
        {
            alignment.setNoteDiff((int)(item->note()) - (int)(prev->note()));
            alignment.setPreLength(item->tick() - prev->tick());
        }

        const Data &data = contours.dictionary->find(alignment);
        if(data.isEmpty())
        {
            continue;
        }

        double noteFrequency = stand::utility::NoteFrequency((int)(item->note()));
        QList<stand::utility::ControlPoint> f0tmp;
        QList<stand::utility::ControlPoint> volumetmp;
        for(int j = 0; j < data.length(); j++)
        {
            stand::utility::ControlPoint p;
            p.tick = item->tick() + data.ticks()[j];
            p.value = noteFrequency * data.f0()[j];
            f0tmp.append(p);
            p.value = data.volume()[j];
            volumetmp.append(p);
        }
        if(!f0tmp.empty())
        {
            contours.f0->replace(f0tmp, f0tmp[0].tick, f0tmp.last().tick);
        }
        if(!volumetmp.empty())
        {
            contours.volume->replace(volumetmp, volumetmp[0].tick, volumetmp.last().tick);
        }
    }

    return true;
}
