#include "EditorWidget.h"

#include "TrackView.h"
#include "ControlArea.h"
#include "ViewArea.h"
#include "PianoView.h"
#include "MeasureView.h"
#include "ViewSettings.h"
#include "SingerView.h"
#include "ControlSelector.h"
#include "TrackSelector.h"
#include "TrackNameView.h"
#include "SequenceModel.h"
#include "VsqImporter.h"

#include "Utility.h"
#include "../configure.h"

#include <QSplitter>
#include <QBoxLayout>
#include <QGridLayout>
#include <QScrollBar>
#include <QUndoStack>

using namespace stand::gui;
using namespace stand::view;
using namespace stand::model;
using namespace stand::utility;

EditorWidget::EditorWidget(QWidget *parent) :
    QWidget(parent)
{
    // test code
    _model = new SequenceModel(this);

    QBoxLayout *layout = new QBoxLayout(QBoxLayout::LeftToRight, this);
    layout->setContentsMargins(0, 0, 0, 0);
    layout->setMargin(0);
    layout->setSpacing(0);
    setLayout(layout);
    QSplitter *splitter = new QSplitter(Qt::Vertical, this);
    layout->addWidget(splitter);

    // 上方のウィジェットを設定する
    QWidget *contentWidget = new QWidget(splitter);
    QGridLayout* gridlayout = new QGridLayout(contentWidget);
    gridlayout->setContentsMargins(0, 0, 0, 0);
    gridlayout->setMargin(0);
    gridlayout->setSpacing(0);
    contentWidget->setLayout(gridlayout);
    splitter->addWidget(contentWidget);

    _trackView = new TrackView(contentWidget);
    ViewSettings *s = _trackView->settings();
    _trackView->setModel(_model);

    gridlayout->addWidget(_trackView, 1, 1);

    ViewArea *area = new ViewArea(contentWidget);
    PianoView *piano = new PianoView(area);
    piano->setSettings(s);
    connect(_trackView->verticalScrollBar(), SIGNAL(valueChanged(int)), area, SLOT(verticalScroll(int)));
    area->setMinimumWidth(96);
    area->addWidget(piano);

    gridlayout->addWidget(area, 1, 0);

    area = new ViewArea(contentWidget);
    MeasureView *measure = new MeasureView(area);
    measure->setSettings(s);
    connect(_trackView->horizontalScrollBar(), SIGNAL(valueChanged(int)), area, SLOT(horizontalScroll(int)));
    area->addWidget(measure);
    area->setResizePolicy(ViewArea::NoResize, ViewArea::Resize);
    gridlayout->addWidget(area, 0, 1);

    QWidget *singer = new SingerView(s, contentWidget);
    gridlayout->addWidget(singer, 0, 0);

    // 下方のウィジェットを設定する
    contentWidget = new QWidget(splitter);
    contentWidget->setMinimumHeight(192);
    gridlayout = new QGridLayout(contentWidget);
    gridlayout->setContentsMargins(0, 0, 0, 0);
    gridlayout->setMargin(0);
    gridlayout->setSpacing(0);
    contentWidget->setLayout(gridlayout);
    splitter->addWidget(contentWidget);

    QWidget *emptyWidget = new ControlSelector(s, contentWidget);
    _controlArea = new ControlArea(_trackView, s, _model->track(0), contentWidget);
    emptyWidget->setFixedWidth(96);

    gridlayout->addWidget(emptyWidget, 0, 0);
    gridlayout->addWidget(_controlArea, 0, 1);
    gridlayout->addWidget(new TrackNameView(this), 1, 0);
    gridlayout->addWidget(new TrackSelector(s, this), 1, 1);

    s->setSnapDiv(4);
    s->setIsSnap(true);

    _currentFilePath = QString::null;
    _framePeriod = 20.0; //stand::DefaultFramePeriod;
    _taskManager = NULL;
}

