#ifndef TIMECOMPUTINGTASK_H
#define TIMECOMPUTINGTASK_H

#include "task/Task.h"
#include "ControlItem.h"
#include <QVector>

namespace stand
{
namespace gui
{
namespace helper
{

class TimeComputingTask : public stand::utility::task::Task
{
    Q_OBJECT
public:
    explicit TimeComputingTask(const QList<stand::utility::ControlPoint> &contour, double framePeriod, double msEnd, QObject *parent = 0);

    void set(const QList<stand::utility::ControlPoint> &contour, double framePeriod, double msEnd);

    inline const QVector<int> &data() const
    {
        return _data;
    }
    inline double framePeriod() const
    {
        return _framePeriod;
    }
    inline bool empty() const
    {
        return _data.empty();
    }
    virtual bool exec();

private:
    void _destroy();

    QVector<int> _data;
    QList<stand::utility::ControlPoint> _tempo;
    double _framePeriod;
    int _lastIndex;
};

}
}
}

#endif // TIMECOMPUTINGTASK_H
