#ifndef WAVEANALYSISTASK_H
#define WAVEANALYSISTASK_H

#include "task/Task.h"
#include "envelope/Envelope.h"

namespace stand
{
namespace model
{
class TrackItem;
class SequenceModel;
}
namespace gui
{
namespace helper
{

class EnvelopeComputingTask;
class TimeComputingTask;

class WaveAnalysisTask : public stand::utility::task::Task
{
    Q_OBJECT
public:
    explicit WaveAnalysisTask(stand::model::SequenceModel *model, stand::model::TrackItem *target, const QString &path, double framePeriod, QObject *parent = 0);
    virtual ~WaveAnalysisTask();

protected:
    virtual bool exec();

private:
    double _framePeriod;
    stand::model::TrackItem *_track;
    stand::model::SequenceModel *_model;

    QString _path;
};

}
}
}

#endif // WAVEANALYSISTASK_H
