#include "MidiChunk.h"

#include "MidiFile.h"
#include "../../utility/Utility.h"

#include <stdint.h>

using namespace stand::io::midi;

MidiChunk::MidiChunk()
{
    for(int i = 0; i <5; i++)
    {
        _header[i] = '\0';
    }
    _data = NULL;
    _length = 0;
}

MidiChunk::~MidiChunk()
{
    _destroy();
}

void MidiChunk::_destroy()
{
    delete[] _data;
    _data = NULL;
    _length = 0;
    for(int i = 0; i <5; i++)
    {
        _header[i] = '\0';
    }
}

bool MidiChunk::set(FILE *fp)
{
    if(!fp)
    {
        return false;
    }

    _destroy();

    fread(_header, sizeof(char), 4, fp);
    if(!is("MTrk"))
    {
        return false;
    }
    int32_t size;
    fread(&size, sizeof(int32_t), 1, fp);
    size = stand::utility::FromBigEndian(size);
    _length = size;
    _data = new char[size];
    int n = fread(_data, sizeof(char), size, fp);
    if(n != size)
    {
        return false;
    }
    return true;
}

bool MidiChunk::is(const char *name) const
{
    bool ret = true;
    for(int i = 0; i < 4; i++)
    {
        ret &= (name[i] == _header[i]);
    }
    return ret;
}
