﻿#ifndef PREFIXMAP_H
#define PREFIXMAP_H

#include <QTextCodec>
#include <QHash>

namespace stand
{
namespace io
{
namespace utau
{

class PrefixMap
{
public:
    PrefixMap();
    bool read(const QString &path, QTextCodec *codec = QTextCodec::codecForName("Shift-JIS"));

    const QString &at(int note) const;
    int indexOf(const QString &key) const
    {
        return _noteNumber.value(key);
    }
    QStringList prefixList() const;

    inline bool isGood() const
    {
        return _isGood;
    }
private:
    QString _prefix[128];
    QHash<QString, int> _noteNumber;

    bool _isGood;
};

}
}
}

#endif // PREFIXMAP_H
