/*!
 * Stand Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU GPL License
 *
 * Stand Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 *  @file MathSet.cpp
 *  @author HAL@shurabaP
 */
#include "MathSet.h"

#include <stdio.h>

double stand::math::interpolateArray( double x, const double *p )
{
    int t = (int)x;
    double r = x - (double)t;
    return ( p[t] * ( 1.0 - r ) + p[t+1] * r );
}

void stand::math::autoCorrelation(double *a, int aLen, const double *y, int yLen)
{
    for(int i = 0; i < aLen; i++)
    {
        a[i] = 0;
        for(int j = 0; j < yLen -i; j++)
        {
            a[i] += y[j] * y[j + i];
        }
    }
}

void stand::math::calculateDelta(double *dst, const double *src, int length)
{
    if(!dst || !src || length <= 1)
    {
        return;
    }

    dst[0] = src[1] - src[0];
    for(int i = 1; i < length - 1; i++)
    {
        dst[i] = (src[i+1] - src[i-1]) / 2.0;
    }
    dst[length - 1] = src[length - 1] - src[length - 2];
}

double *stand::math::average(double *dst, double **src, int n, int dim)
{
    if(!dst || !src || !src[0] || n <= 0 || dim <= 0)
    {
        return NULL;
    }
    for(int i = 0; i < dim; i++)
    {
        dst[i] = 0;
    }

    for(int i = 0; i < n; i++)
    {
        for(int j = 0; j < dim; j++)
        {
            dst[j] += src[i][j] / (double)n;
        }
    }
    return dst;
}

double *stand::math::deviation(double *dst, double **src, int n, int dim, const double *avr)
{
    double *tmp = NULL;
    if(!dst || !src || !src[0] || n <= 0 || dim <= 0)
    {
        return NULL;
    }
    if(!avr)
    {
        tmp = new double[dim];
        average(tmp, src, n, dim);
        avr = tmp;
    }

    for(int i = 0; i < dim; i++)
    {
        dst[i] = 0;
    }
    for(int i = 0; i < n; i++)
    {
        for(int j = 0; j < dim; j++)
        {
            double diff = src[i][j] - avr[j];
            dst[j] += diff * diff / (double) n;
        }
    }

    delete[] tmp;

    return dst;
}
