#ifndef MATRIX_H
#define MATRIX_H

namespace stand
{
namespace math
{
namespace matrix
{

/*!
 *  @brief N x N 行列からガウスの消去法により逆行列を求めます．
 *  @param[out] inv 求めた逆行列．
 *  @param[in] src 逆行列を求めたい行列．
 *  @param[in] dim 行列の次元．
 */
void GaussianElimination(double **inv, double **src, int dim);

/*!
 *  @brief N x N 行列の行列式を求めます．
 *  @param[in] src 行列式を求めたい行列．
 *  @param[in] dim 行列の次元．
 */
double Determinant(double **src, int dim);

/*!
 *  @brief 倍精度型の行列を得ます．
 */
void CreateMatarix(double ***dst, int n, int m);

/*!
 *  @brief CreateMatrix で確保したメモリを破棄します．
 *  @param[in] dst 解放したい行列
 */
void DestroyMatrix(double ***dst);

/*!
 *  @brief 分散共分散行列を求めます．行列は dim x dim の二次元配列として扱われます．
 *  @param[out] dst 分散共分散行列
 *  @param[in] x データ列
 *  @param[in] mu 平均ベクトル
 *  @param[in] dim データの次元
 *  @param[in] n データ数
 */
void Covariance(double **dst, double **x, const double *mu, int dim, int n);

/*!
 *  @brief 行列の掛け算を行います．
 *  @param[out] dst 計算結果を返す行列． n x l の二次元配列が確保されている必要がある．
 *  @param[in] A n x m 行列
 *  @param[in] B m x l 行列
 */
void Multiple(double **dst, double **A, double **B, int n, int m, int l);

}
}
}

#endif // MATRIX_H
