#ifndef ABSTRACTEVENT_H
#define ABSTRACTEVENT_H

#include <QString>
#include "importer/Interpreter.h"

namespace stand
{
namespace sequence
{

class Track;

class AbstractEvent : public importer::Interpreter
{
public:
    explicit AbstractEvent(Track *parent, int tick)
    {
        _parent = parent;
        setTick(tick);
    }

    virtual ~AbstractEvent()
    {
    }

    virtual Interpreter* interpret(const QString &line) = 0;

    inline const QString &type() const
    {
        return _type;
    }

    inline void setType(const QString &type)
    {
        _type = type;
    }

    int tick() const
    {
        return _tick;
    }

    void setTick(int tick)
    {
        _tick = tick;
    }

    inline Track *parent()
    {
        return _parent;
    }

protected:

    Track *_parent;
    int _tick;
    QString _type;
};

}
}

#endif // ABSTRACTEVENT_H
