#include "ControlCurve.h"

#include <QStringList>

using namespace stand::sequence;

ControlCurve::ControlCurve(double defaultValue)
{
    clear(defaultValue);
}

ControlCurve::~ControlCurve()
{
}

void ControlCurve::add(int tick, double val)
{
    int i;

    for(i = 0; i < _data.size(); i++)
    {
        if(_data[i].tickBegin <= tick && tick < _data[i].tickEnd)
        {
            i++;
            break;
        }
    }
    if(_data[i-1].val == val)
    {
        return;
    }
    if(i < _data.size() && _data[i].val == val)
    {
        _data[i].tickBegin = tick;
        return;
    }
    Point p = {tick, _data[i-1].tickEnd, val};
    _data[i-1].tickEnd = tick;
    _data.insert(i, p);
}

importer::Interpreter *ControlCurve::interpret(const QString &line)
{
    QStringList sl = line.split(" ", QString::SkipEmptyParts);
    if(sl.size() == 2)
    {
        add(sl.at(0).toInt(), sl.at(1).toDouble());
    }
    return NULL;
}

double ControlCurve::defaultValue(const QString &name)
{
    return 64.0;
}

const QString ControlCurve::toString() const
{
    QString retval;

    for(int i = 1; i < _data.size(); i++)
    {
        retval += name() + " " + QString::number(_data[i].tickBegin) + " " + QString::number(_data[i].val) + "\n";
    }

    return retval;
}

double ControlCurve::at(int tick) const
{
    if(_data.empty())
    {
        return 0;
    }
    for(int i = 0; i < _data.size(); i++)
    {
        if(_data[i].tickBegin <= tick && tick <= _data[i].tickEnd)
        {
            return _data[i].val;
        }
    }
    return _data.last().val;
}
