#ifndef MEASURE_H
#define MEASURE_H

#include "importer/Interpreter.h"

#include <QVector>

namespace stand
{
namespace sequence
{

class Measure : public importer::Interpreter
{
public:
    struct Beat
    {
        int endTick;
        int beginTick;
        int up;
        int down;
    };

    Measure();
    ~Measure();

    inline int size() const
    {
        return _data.size();
    }

    inline bool empty() const
    {
        return (_data.size() < 2);
    }

    const Beat &at(int tick) const;

    inline void clear()
    {
        _data.clear();
        Beat b = {INT_MIN, INT_MAX, 4, 4};
        _data.push_back(b);
    }

    inline const QVector<Beat> &data() const
    {
        return _data;
    }

    importer::Interpreter *interpret(const QString &line);
    const QString toString() const;

private:
    void _add(int tick, int up, int down);

    QVector<Beat> _data;
};

}
}

#endif // MEASURE_H
