#ifndef TRACK_H
#define TRACK_H

#include <QList>
#include <QHash>
#include <QString>
#include <QVector>

#include "importer/Interpreter.h"

namespace stand
{
namespace utility
{
class Envelope;
}

namespace sequence
{

class AbstractEvent;
class NoteEvent;
class ControlCurve;
class Sequence;

class Track : public importer::Interpreter
{
public:
    Track(Sequence *parent);
    ~Track();

    /*!
     *  @brief tick 時刻に対応するイベントを得ます
     *  @param[in] tick イベントを得たい時刻
     *  @return 該当時刻のイベント
     *  @retval NULL 該当時刻にイベントは存在しない．
     */
    AbstractEvent *eventAt(int tick);
    virtual Interpreter* interpret(const QString &line);

    void addNote(NoteEvent *n);
    void removeNote(NoteEvent *n);

    const QVector<NoteEvent *> notes();

    const QString toString() const;

    bool isHead(int m) const;

    /*!
     *  @brief トラックの tick 長を求めます．
     *  @return トラックの tick 長
     */
    int length() const;

    /*!
     *  @brief トラックが有効かどうか確認します．
     *         モノフォニックであるとき有効だと判断します．
     *  @return 有効かどうか．
     */
    bool isValid() const;

    void validate();

    inline const Sequence *sequence() const
    {
        return _parent;
    }

    inline int size() const
    {
        return _events.size();
    }

    inline bool empty() const
    {
        return _events.empty();
    }

    void addControl(ControlCurve *c);
    const QList<ControlCurve *> &curves() const
    {
        return _curves;
    }

private:
    void _destroy();
    QList<AbstractEvent *> _events;
    QList<ControlCurve *> _curves;
    Sequence *_parent;

    Interpreter *_createControl(const QString &name);
    Interpreter *_createNote(const QString &name);
    Interpreter *_createSinger(const QString &name);

    static QHash<QString, Interpreter *(Track::*)(const QString &)> Factories;
};

}
}

#endif // TRACK_H
