#include "SimpleImporter.h"

#include <QFile>
#include <QTextStream>
#include <QTextCodec>
#include <QStringList>

using namespace stand::sequence::importer;

SimpleImporter::SimpleImporter(QTextCodec *codec)
{
    _file = NULL;
    _stream = NULL;
    setCodec(codec);
}

SimpleImporter::~SimpleImporter()
{
    _destroy();
}

void SimpleImporter::_destroy()
{
    delete _stream;
    delete _file;
    _stream = NULL;
    _file = NULL;
}

void SimpleImporter::setCodec(QTextCodec *codec)
{
    this->_codec = codec;
}

bool SimpleImporter::open(const QString &path)
{
    _destroy();
    _file = new QFile(path);
    if(!_file->exists())
    {
        qDebug("SimpleImporter::open(%s); // File not found.", path.toUtf8().data());
        return false;
    }
    if(!_file->open(QIODevice::ReadOnly | QIODevice::Text))
    {
        qDebug("SimpleImporter::open(%s); // File could not be opened.", path.toUtf8().data());
        return false;
    }

    _stream = new QTextStream(_file);
    _stream->setCodec(_codec);

    return true;
}

bool SimpleImporter::isOpen() const
{
    if(!_file || !_stream)
    {
        return false;
    }
    bool retval = _file->isOpen();
    retval &= !_stream->atEnd();
    return retval;
}

bool SimpleImporter::eof() const
{
    if(!isOpen())
    {
        return true;
    }
    return _stream->atEnd();
}

bool SimpleImporter::pop(QString &oper)
{
    if(!isOpen())
    {
        return false;
    }
    oper = _stream->readLine();
    return true;
}
