/*!
 *
 */
#ifndef SIMPLEIMPORTER_H
#define SIMPLEIMPORTER_H

#include "Importer.h"
#include <QTextCodec>

class QFile;
class QTextStream;

namespace stand
{
namespace sequence
{
namespace importer
{

class SimpleImporter : public Importer
{
public:
    SimpleImporter(QTextCodec *codec = QTextCodec::codecForLocale());
    ~SimpleImporter();

    bool pop(QString &oper);
    bool open(const QString &path);
    bool eof() const;
    bool isOpen() const;

    void setCodec(QTextCodec *codec = QTextCodec::codecForLocale());

private:
    void _destroy();

    QTextStream *_stream;
    QTextCodec *_codec;
    QFile *_file;
};

}
}
}

#endif // SIMPLEIMPORTER_H
