#include "EchoesBenchmark.h"

#include "Dictionary.h"
#include "Alignment.h"

#include "ControlItem.h"

#include <QTest>

EchoesBenchmark::EchoesBenchmark(QObject *parent) :
    QObject(parent)
{
}

void EchoesBenchmark::dictionary_data()
{
    QTest::addColumn<QString>("dictPath");

    QTest::newRow("nullData") << "";
    QTest::newRow("about600Data") << "test\\data\\ioTest1.dict";
}

void EchoesBenchmark::dictionary()
{
    QFETCH(QString, dictPath);
    stand::echoes::Dictionary dictionary;
    dictionary.read(dictPath);

    QBENCHMARK {
        stand::echoes::Alignment key(rand() % 12 + 60, rand() % 12, rand() % 480, rand()% 960);
        const stand::echoes::Data &d = dictionary.find(key);
    }
}

