#include "XmlBenchmark.h"

#include <QFile>
#include <QTest>
#include <QDomDocument>

#include "SequenceModel.h"

using namespace stand::model;

XmlBenchmark::XmlBenchmark(QObject *parent) :
    QObject(parent)
{
}

void XmlBenchmark::xmlRead_data()
{
    QTest::addColumn<QString>("path");

    QTest::newRow("empty") << QString();
    QTest::newRow("test1") << QString("test.stfx");
    QTest::newRow("test2") << QString("test\\data\\test.stfx");
}

void XmlBenchmark::xmlRead()
{
    QFETCH(QString, path);

    QBENCHMARK
    {
        QFile file(path);
        if(file.exists() && file.open(QIODevice::ReadOnly))
        {
            QDomDocument doc;
            QString errorMsg;
            int errorLine, errorColumn;
            doc.setContent(&file, true, &errorMsg, &errorLine, &errorColumn);
        }
    }
}

void XmlBenchmark::sequenceRead_data()
{
    QTest::addColumn<QString>("path");

    QTest::newRow("test1") << QString("test.stfx");
    QTest::newRow("test2") << QString("test\\data\\test.stfx");
}

void XmlBenchmark::sequenceRead()
{
    QFETCH(QString, path);

    SequenceModel model;
    QBENCHMARK
    {
        model.read(path);
    }
}

void XmlBenchmark::sequenceWrite_data()
{
    QTest::addColumn<QString>("path");

    QTest::newRow("test1") << QString("test.stfx");
    QTest::newRow("test2") << QString("test\\data\\test.stfx");
}

void XmlBenchmark::sequenceWrite()
{
    QFETCH(QString, path);

    SequenceModel model;
    model.read(path);
    QBENCHMARK
    {
        model.write("log.txt");
    }
}

