#ifndef TASKTEST_H
#define TASKTEST_H

#include <QObject>
#include "../utility/task/Task.h"

#include <QMutex>
#include <QWaitCondition>

class TestTask : public stand::utility::task::Task
{
public:
    explicit TestTask(QObject *parent = 0);
    bool exec();

    QString text() const
    {
        return "TestTask; Just sleep 10ms.";
    }
};

class TaskTest : public QObject
{
    Q_OBJECT
public:
    explicit TaskTest(QObject *parent = 0);

public slots:
    void finished();

private slots:
    void testTaskTest();
    void testWorkerTest();
    void testManagerTest();

private:
    QMutex wait;
    QWaitCondition condition;
};

#endif // TASKTEST_H
