#include "F0Computer.h"

#include "Envelope.h"
#include "dsp/world.h"

using namespace stand::utility::envelope;
using namespace stand::utility;
using namespace stand::math::dsp;

bool F0Computer::compute(Envelope *dst, const double *x, int xLen, int fs, double framePeriod) const
{
    if(!dst || !x || xLen <= 0 || fs <= 0 || framePeriod <= 0)
    {
        qDebug("VolumeComputer::compute(%d, %d, %d, %d, %f); // invalid args.", dst, x, xLen, fs, framePeriod);
        return false;
    }

    int tLen = GetSamplesForDIO(fs, xLen, framePeriod);
    double *t = new double[tLen];
    double *f0 = new double[tLen];

    Dio(x, xLen, fs, framePeriod, t, f0);
    dst->set(f0, tLen, framePeriod, true);

    delete[] t;

    return true;
}
