﻿#include "VolumeComputer.h"

#include "WaveBuffer.h"
#include "Envelope.h"

#include <float.h>

using namespace stand::utility::envelope;

bool VolumeComputer::compute(Envelope *dst, const double *x, int xLen, int fs, double framePeriod) const
{
    if(!dst || !x || xLen <= 0 || fs <= 0 || framePeriod <= 0)
    {
        qDebug("VolumeComputer::compute(%d, %d, %d, %d, %f); // invalid args.", dst, x, xLen, fs, framePeriod);
        return false;
    }

    const int wLen = 2048;

    double msLen = (double)xLen / (double)fs * 1000.0;
    int tLen = 0.5 + msLen / framePeriod;

    double *data = new double[tLen];
    double maxval = -DBL_MAX;
    for(int i = 0; i < tLen; i++)
    {
        double ms = i * framePeriod;
        double sum = 0;

        int index = ms * fs / 1000.0;
        int begin = index - wLen / 2;
        int end = index + wLen / 2;
        int c = 0, t;

        for(t = begin; t < 0; t++);
        for(; t < end && t < xLen; t++)
        {
            sum += x[t] * x[t];
            c++;
        }
        sum = sum / c;
        data[i] = 8 * log10(sum + DBL_MIN);

        if(maxval < data[i])
        {
            maxval = data[i];
        }
    }
    for(int i = 0; i < tLen; i++)
    {
        data[i] -= maxval;
    }

    dst->set(data, tLen, framePeriod, true);

    return true;
}
