#include "Worker.h"

using namespace stand::utility::task;

Worker::Worker(const QList<Task *> &data, QObject *parent) :
    Task(parent)
{
    _data = data;

    for(int i = 0; i < _data.size(); i++)
    {
        connect(this, SIGNAL(canceled()), _data[i], SLOT(cancel()));
    }
}

Worker::~Worker()
{
    for(int i = 0; i < _data.size(); i++)
    {
        disconnect(this, SIGNAL(canceled()), _data[i], SLOT(cancel()));
    }
}

bool Worker::exec()
{
    emit progress(0);
    for(int i = 0; i < _data.size() && !isCanceled(); i++)
    {
        emit textChanged(_data[i]->text());
        _data[i]->run();
        emit progress(i * 100 / _data.size());
    }

    return (!isCanceled());
}
