/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.client.authentication;

import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.cactus.Cookie;
import org.apache.cactus.WebRequest;
import org.apache.cactus.client.authentication.AbstractAuthentication;
import org.apache.cactus.internal.WebRequestImpl;
import org.apache.cactus.internal.client.connector.http.HttpClientConnectionHelper;
import org.apache.cactus.internal.configuration.Configuration;
import org.apache.cactus.internal.configuration.WebConfiguration;
import org.apache.cactus.util.ChainedRuntimeException;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class FormAuthentication
extends AbstractAuthentication {
    private static final Log LOGGER;
    private int expectedAuthResponse = 302;
    private URL securityCheckURL;
    private String sessionCookieName = "JSESSIONID";
    private Cookie jsessionCookie;
    private WebRequest securityRequest = new WebRequestImpl();
    static /* synthetic */ Class class$0;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;

    static {
        Factory factory = new Factory("FormAuthentication.java", Class.forName("org.apache.cactus.client.authentication.FormAuthentication"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-configure-org.apache.cactus.client.authentication.FormAuthentication-org.apache.commons.httpclient.HttpState:org.apache.commons.httpclient.HttpMethod:org.apache.cactus.WebRequest:org.apache.cactus.internal.configuration.Configuration:-theState:theMethod:theRequest:theConfiguration:--void-"), 99);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setSecurityCheckURL-org.apache.cactus.client.authentication.FormAuthentication-java.net.URL:-theUrl:--void-"), 131);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getSecurityCheckURL-org.apache.cactus.client.authentication.FormAuthentication-org.apache.cactus.internal.configuration.Configuration:-theConfiguration:--java.net.URL-"), 144);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setSessionCookieName-org.apache.cactus.client.authentication.FormAuthentication-java.lang.String:-theName:--void-"), 187);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setExpectedAuthResponse-org.apache.cactus.client.authentication.FormAuthentication-int:-theExpectedCode:--void-"), 212);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-authenticate-org.apache.cactus.client.authentication.FormAuthentication-org.apache.cactus.WebRequest:org.apache.cactus.internal.configuration.Configuration:-theRequest:theConfiguration:--void-"), 351);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.cactus.client.authentication.FormAuthentication");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = LogFactory.getLog((Class)clazz);
    }

    public FormAuthentication(String theName, String thePassword) {
        super(theName, thePassword);
    }

    public void configure(HttpState httpState, HttpMethod httpMethod, WebRequest webRequest, Configuration configuration) {
        HttpState httpState2 = httpState;
        HttpMethod httpMethod2 = httpMethod;
        WebRequest webRequest2 = webRequest;
        Configuration configuration2 = configuration;
        Object[] objectArray = new Object[]{httpState2, httpMethod2, webRequest2, configuration2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        FormAuthentication.configure_aroundBody1$advice(this, httpState2, httpMethod2, webRequest2, configuration2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public WebRequest getSecurityRequest() {
        return this.securityRequest;
    }

    public void setSecurityCheckURL(URL uRL) {
        URL uRL2 = uRL;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)uRL2);
        FormAuthentication.setSecurityCheckURL_aroundBody3$advice(this, uRL2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public URL getSecurityCheckURL(Configuration configuration) {
        Configuration configuration2 = configuration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)configuration2);
        return (URL)FormAuthentication.getSecurityCheckURL_aroundBody5$advice(this, configuration2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    private String getSessionCookieName() {
        return this.sessionCookieName;
    }

    public void setSessionCookieName(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string2);
        FormAuthentication.setSessionCookieName_aroundBody7$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    protected int getExpectedAuthResponse() {
        return this.expectedAuthResponse;
    }

    public void setExpectedAuthResponse(int n) {
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        FormAuthentication.setExpectedAuthResponse_aroundBody9$advice(this, n2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    private Cookie getCookie(HttpURLConnection theConnection, String theTarget) {
        int i = 1;
        String key = theConnection.getHeaderFieldKey(i);
        while (key != null) {
            if (key.equalsIgnoreCase("set-cookie")) {
                String cookiestr = theConnection.getHeaderField(i);
                String nameValue = cookiestr.substring(0, cookiestr.indexOf(";"));
                int equalsChar = nameValue.indexOf("=");
                String name = nameValue.substring(0, equalsChar);
                String value = nameValue.substring(equalsChar + 1);
                if (name.equalsIgnoreCase(theTarget)) {
                    return new Cookie(theConnection.getURL().getHost(), name, value);
                }
            }
            key = theConnection.getHeaderFieldKey(++i);
        }
        return null;
    }

    protected void checkPreAuthResponse(HttpURLConnection theConnection) throws Exception {
        if (theConnection.getResponseCode() >= 400) {
            throw new Exception("Received a status code [" + theConnection.getResponseCode() + "] and was expecting less than 400");
        }
    }

    private Cookie getSecureSessionIdCookie(WebRequest theRequest, Configuration theConfiguration) {
        HttpURLConnection connection;
        String resource = null;
        try {
            WebConfiguration webConfig = (WebConfiguration)theConfiguration;
            resource = webConfig.getRedirectorURL(theRequest);
            HttpClientConnectionHelper helper = new HttpClientConnectionHelper(resource);
            WebRequestImpl request = new WebRequestImpl((WebConfiguration)theConfiguration);
            connection = helper.connect(request, theConfiguration);
            this.checkPreAuthResponse(connection);
        }
        catch (Throwable e) {
            throw new ChainedRuntimeException("Failed to connect to the secured redirector: " + resource, e);
        }
        return this.getCookie(connection, this.getSessionCookieName());
    }

    protected void checkAuthResponse(HttpURLConnection theConnection) throws Exception {
        if (theConnection.getResponseCode() != this.getExpectedAuthResponse()) {
            throw new Exception("Received a status code [" + theConnection.getResponseCode() + "] and was expecting a [" + this.getExpectedAuthResponse() + "]");
        }
    }

    public void authenticate(WebRequest webRequest, Configuration configuration) {
        WebRequest webRequest2 = webRequest;
        Configuration configuration2 = configuration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)webRequest2, (Object)configuration2);
        FormAuthentication.authenticate_aroundBody11$advice(this, webRequest2, configuration2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    private static final void configure_aroundBody0(FormAuthentication formAuthentication, HttpState httpState, HttpMethod httpMethod, WebRequest webRequest, Configuration configuration, JoinPoint joinPoint) {
        if (formAuthentication.jsessionCookie == null) {
            formAuthentication.authenticate(webRequest, configuration);
        }
        if (formAuthentication.jsessionCookie != null) {
            webRequest.addCookie(formAuthentication.jsessionCookie);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Object configure_aroundBody1$advice(FormAuthentication this_, HttpState ajc_aroundClosure, HttpMethod thisJoinPoint, WebRequest webRequest, Configuration configuration, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void logger;
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature(logAspect, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            FormAuthentication.configure_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint, (WebRequest)target, (Configuration)logger, joinPoint);
            Object var11_12 = null;
            log.debug((Object)(String.valueOf('>') + joinPoint2.getSignature().getName()));
            return var11_12;
        }
        AroundClosure aroundClosure3 = aroundClosure;
        FormAuthentication.configure_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint, (WebRequest)target, (Configuration)logger, joinPoint);
        return null;
    }

    private static final void setSecurityCheckURL_aroundBody2(FormAuthentication formAuthentication, URL uRL, JoinPoint joinPoint) {
        formAuthentication.securityCheckURL = uRL;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object setSecurityCheckURL_aroundBody3$advice(FormAuthentication this_, URL ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            FormAuthentication.setSecurityCheckURL_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        FormAuthentication.setSecurityCheckURL_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final URL getSecurityCheckURL_aroundBody4(FormAuthentication formAuthentication, Configuration configuration, JoinPoint joinPoint) {
        if (formAuthentication.securityCheckURL == null) {
            String string = String.valueOf(((WebConfiguration)configuration).getContextURL()) + "/j_security_check";
            try {
                formAuthentication.securityCheckURL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ChainedRuntimeException("Unable to create default Security Check URL [" + string + "]");
            }
        }
        LOGGER.debug((Object)("Using security check URL [" + formAuthentication.securityCheckURL + "]"));
        return formAuthentication.securityCheckURL;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object getSecurityCheckURL_aroundBody5$advice(FormAuthentication this_, Configuration ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var10_8 = logger;
            URL uRL = FormAuthentication.getSecurityCheckURL_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint);
            StringBuffer stringBuffer = new StringBuffer(result.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append(uRL);
            stringBuffer.append(']');
            log.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return uRL;
        }
        void var11_11 = logger;
        return FormAuthentication.getSecurityCheckURL_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint);
    }

    private static final void setSessionCookieName_aroundBody6(FormAuthentication formAuthentication, String string, JoinPoint joinPoint) {
        if (string != null) {
            formAuthentication.sessionCookieName = string;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Object setSessionCookieName_aroundBody7$advice(FormAuthentication this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            FormAuthentication.setSessionCookieName_aroundBody6(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        FormAuthentication.setSessionCookieName_aroundBody6(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final void setExpectedAuthResponse_aroundBody8(FormAuthentication formAuthentication, int n, JoinPoint joinPoint) {
        formAuthentication.expectedAuthResponse = n;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object setExpectedAuthResponse_aroundBody9$advice(FormAuthentication this_, int ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            FormAuthentication.setExpectedAuthResponse_aroundBody8(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        FormAuthentication.setExpectedAuthResponse_aroundBody8(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final void authenticate_aroundBody10(FormAuthentication formAuthentication, WebRequest webRequest, Configuration configuration, JoinPoint joinPoint) {
        formAuthentication.jsessionCookie = formAuthentication.getSecureSessionIdCookie(webRequest, configuration);
        try {
            HttpClientConnectionHelper httpClientConnectionHelper = new HttpClientConnectionHelper(formAuthentication.getSecurityCheckURL(configuration).toString());
            WebRequest webRequest2 = formAuthentication.getSecurityRequest();
            ((WebRequestImpl)webRequest2).setConfiguration(configuration);
            webRequest2.addCookie(formAuthentication.jsessionCookie);
            webRequest2.addParameter("j_username", formAuthentication.getName(), "POST");
            webRequest2.addParameter("j_password", formAuthentication.getPassword(), "POST");
            HttpURLConnection httpURLConnection = httpClientConnectionHelper.connect(webRequest2, configuration);
            formAuthentication.checkAuthResponse(httpURLConnection);
        }
        catch (Throwable throwable) {
            formAuthentication.jsessionCookie = null;
            throw new ChainedRuntimeException("Failed to authenticate the principal", throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Object authenticate_aroundBody11$advice(FormAuthentication this_, WebRequest ajc_aroundClosure, Configuration thisJoinPoint, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void result;
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            FormAuthentication.authenticate_aroundBody10(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
            Object var9_10 = null;
            log.debug((Object)(String.valueOf('>') + joinPoint2.getSignature().getName()));
            return var9_10;
        }
        void var11_11 = result;
        FormAuthentication.authenticate_aroundBody10(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
        return null;
    }
}

