/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.filter;

import info.dragonlady.filter.LogLevel;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugLogFilter
implements Filter {
    private String[] smartLogs = new String[]{"getTimestamp", "stopTimer", "getRequestHeader", "getResponseHeader"};
    private String[] middleLogs = new String[]{"getTimestamp", "stopTimer", "getBeforeAttributes", "getAfterAttributes", "getRequestHeader", "getResponseHeader"};
    private String[] fullLogs = new String[]{"getTimestamp", "stopTimer", "getBeforeAttributes", "getAfterAttributes", "getRequestHeader", "getResponseHeader", "getRequest"};
    private String[] debugLogs = new String[]{"getTimestamp", "stopTimer", "getBeforeAttributes", "getAfterAttributes", "getRequestHeader", "getResponseHeader", "getRequest", "getResponse"};
    private List<String> targetLogs = null;
    private int responseLogMaxSize = 128;
    private long startTime = 0L;
    private final String logFilePrefix = "filterlog_";
    private final String logFileSuffix = ".log";
    protected LogLevel debugMode = LogLevel.none;
    protected File logDirPath = null;
    protected boolean logRotate = true;
    protected int maxGeneration = 7;
    protected String sessionBefore = null;
    protected HashMap<String, String> logInfoMap = new HashMap();

    protected String getMthodName() {
        Exception e = new Exception();
        if (e.getStackTrace().length > 1) {
            StackTraceElement stack = e.getStackTrace()[1];
            return stack.getMethodName();
        }
        return "unknown";
    }

    protected void getTimestamp() {
        Calendar cal = Calendar.getInstance();
        Object[] date = new Object[]{cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14)};
        MessageFormat mf = new MessageFormat("{0,number,0000}/{1,number,00}/{2,number,00} {3,number,00}:{4,number,00}:{5,number,00}.{6,number,000}");
        this.logInfoMap.put(this.getMthodName(), mf.format(date));
    }

    protected void startTimer() {
        this.startTime = System.nanoTime();
    }

    protected void stopTimer() {
        long procTime = System.nanoTime() - this.startTime;
        this.logInfoMap.put(this.getMthodName(), "PROCESS TIME:" + String.valueOf(procTime) + " nano sec");
    }

    protected void getBeforeAttributes(HttpSession session) {
        if (session == null) {
            this.logInfoMap.put(this.getMthodName(), "SESSION ATTRIBUTE(before):none");
            return;
        }
        StringBuffer sessionInfo = new StringBuffer("SESSION ATTRIBUTE(before)[" + session.getId() + "]:");
        Enumeration keys = session.getAttributeNames();
        sessionInfo.append("{");
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            String val = session.getAttribute(key) == null ? new String() : session.getAttribute(key).toString();
            sessionInfo.append("[" + key);
            sessionInfo.append("=");
            sessionInfo.append(String.valueOf(val) + "]");
            if (!keys.hasMoreElements()) continue;
            sessionInfo.append(",");
        }
        sessionInfo.append("}");
        this.logInfoMap.put(this.getMthodName(), sessionInfo.toString());
    }

    protected void getAfterAttributes(HttpSession session) {
        if (session == null) {
            this.logInfoMap.put(this.getMthodName(), "SESSION ATTRIBUTE(after):none");
            return;
        }
        StringBuffer sessionInfo = new StringBuffer("SESSION ATTRIBUTE(after)[" + session.getId() + "]:");
        Enumeration keys = session.getAttributeNames();
        sessionInfo.append("{");
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            String val = session.getAttribute(key) == null ? new String() : session.getAttribute(key).toString();
            sessionInfo.append("[" + key);
            sessionInfo.append("=");
            sessionInfo.append(String.valueOf(val) + "]");
            if (!keys.hasMoreElements()) continue;
            sessionInfo.append(",");
        }
        sessionInfo.append("}");
        this.logInfoMap.put(this.getMthodName(), sessionInfo.toString());
    }

    protected void getRequestHeader(HttpServletRequest request) {
        StringBuffer headerInfo = new StringBuffer();
        Enumeration keys = request.getHeaderNames();
        headerInfo.append("REQUEST HEADERS:{");
        headerInfo.append("[REQUEST_PATH=");
        headerInfo.append(String.valueOf(request.getRequestURI()) + "]");
        if (keys.hasMoreElements()) {
            headerInfo.append(",");
        }
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            String val = request.getHeader(key) == null ? new String() : request.getHeader(key);
            headerInfo.append("[" + key);
            headerInfo.append("=");
            headerInfo.append(String.valueOf(val) + "]");
            if (!keys.hasMoreElements()) continue;
            headerInfo.append(",");
        }
        headerInfo.append("}");
        this.logInfoMap.put(this.getMthodName(), headerInfo.toString());
    }

    protected void getResponseHeader(DebuglogResponseWrapper response) {
        this.logInfoMap.put(this.getMthodName(), "RESPONSE HEADERS:" + response.toString());
    }

    protected void getRequest(ServletRequest request) {
        this.logInfoMap.put(this.getMthodName(), "REQUEST VALUE:" + this.getRequest(request, request.getParameterNames()));
    }

    private String getRequest(ServletRequest request, Enumeration keys) {
        StringBuffer result = new StringBuffer("{");
        while (keys.hasMoreElements()) {
            Object keyObj = keys.nextElement();
            String key = keyObj != null ? keyObj.toString() : "";
            String val = "";
            try {
                val = new String(request.getParameter(key).getBytes("iso-8859-1"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            result.append("[" + key);
            result.append("=");
            result.append(String.valueOf(val) + "]");
            if (!keys.hasMoreElements()) continue;
            result.append(",");
        }
        result.append("}");
        return result.toString();
    }

    protected void getResponse(DebuglogResponseWrapper response) {
        this.logInfoMap.put(this.getMthodName(), "RESPONSE VALUDE:" + response.getResult() + "++" + response.getWriterBuffer());
    }

    protected String get_yyyymmdd() {
        Calendar cal = Calendar.getInstance();
        Object[] date = new Object[]{cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14)};
        MessageFormat mf = new MessageFormat("{0,number,0000}{1,number,00}{2,number,00}{3,number,00}{4,number,00}{5,number,00}{6,number,000}");
        return mf.format(date);
    }

    protected void mkDir() {
        if (!this.logDirPath.exists()) {
            this.logDirPath.mkdirs();
        }
    }

    protected void writeException(Exception ex) {
        if (this.logDirPath == null) {
            return;
        }
        try {
            this.mkDir();
            if (this.logDirPath.isDirectory()) {
                String canPath = this.logDirPath.getCanonicalPath();
                canPath = canPath.endsWith("/") ? canPath : String.valueOf(canPath) + "/";
                canPath = String.valueOf(canPath) + "exception_" + this.get_yyyymmdd() + ".log";
                PrintStream ps = new PrintStream(new FileOutputStream(canPath));
                ex.printStackTrace(ps);
                ps.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int logDate(String fileName) {
        int result = Integer.MAX_VALUE;
        try {
            String dateString = fileName.substring("filterlog_".length(), fileName.lastIndexOf(".log"));
            if (dateString.length() == 8) {
                result = Integer.parseInt(dateString);
            }
        }
        catch (Exception e) {
            result = Integer.MAX_VALUE;
        }
        return result;
    }

    protected void deleteLogFile(Vector<String> logFilesList, String basePath) throws IOException {
        String oldestFile = new String();
        int oldtest = Integer.MAX_VALUE;
        int i = 0;
        while (i < logFilesList.size()) {
            int logDate = this.logDate(logFilesList.get(i));
            if (logDate < oldtest) {
                oldestFile = logFilesList.get(i);
                oldtest = logDate;
            }
            ++i;
        }
        if (logFilesList.size() >= this.maxGeneration) {
            logFilesList.remove(oldestFile);
            oldestFile = String.valueOf(basePath) + oldestFile;
            File deleteFile = new File(oldestFile);
            deleteFile.delete();
            this.deleteLogFile(logFilesList, basePath);
        }
    }

    protected File selectLogFile() throws IOException {
        String targetfileName = "filterlog_" + this.get_yyyymmdd().substring(0, 8) + ".log";
        List<String> logFilesList = Arrays.asList(this.logDirPath.list(new LogFilenameFilter()));
        String basePath = this.logDirPath.getCanonicalPath();
        String string = basePath = basePath.endsWith("/") ? basePath : String.valueOf(basePath) + "/";
        if (!this.logRotate) {
            targetfileName = String.valueOf(basePath) + "filterlog_" + "debug" + ".log";
            return new File(targetfileName);
        }
        if (logFilesList.contains(targetfileName)) {
            targetfileName = String.valueOf(basePath) + targetfileName;
            return new File(targetfileName);
        }
        this.deleteLogFile(new Vector<String>(logFilesList), basePath);
        targetfileName = String.valueOf(basePath) + targetfileName;
        return new File(targetfileName);
    }

    protected void writeLog(HttpServletRequest request, DebuglogResponseWrapper response) throws IOException {
        this.getRequestHeader(request);
        this.getResponseHeader(response);
        if (this.debugMode == LogLevel.full || this.debugMode == LogLevel.debug) {
            this.getRequest((ServletRequest)request);
            if (this.debugMode == LogLevel.debug) {
                this.getResponse(response);
            }
        }
        File targetFile = this.selectLogFile();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(targetFile, true))));
        StringBuffer logData = new StringBuffer();
        int i = 0;
        while (i < this.targetLogs.size()) {
            String temp = this.logInfoMap.get(this.targetLogs.get(i)) == null ? String.valueOf(this.targetLogs.get(i)) + ":NONE" : this.logInfoMap.get(this.targetLogs.get(i));
            logData.append(temp.replaceAll("[\r|\n|\r\n]", "\\\\n"));
            if (i < this.targetLogs.size() - 1) {
                logData.append("\n\t");
            }
            ++i;
        }
        pw.println(logData.toString());
        pw.close();
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.debugMode == LogLevel.none) {
            chain.doFilter(request, response);
        } else {
            try {
                this.getBeforeAttributes(((HttpServletRequest)request).getSession(false));
                DebuglogResponseWrapper responseWrpper = new DebuglogResponseWrapper((HttpServletResponse)response);
                this.startTimer();
                chain.doFilter(request, (ServletResponse)responseWrpper);
                responseWrpper.writerFlush();
                this.stopTimer();
                this.getTimestamp();
                this.getAfterAttributes(((HttpServletRequest)request).getSession(false));
                this.writeLog((HttpServletRequest)request, responseWrpper);
            }
            catch (ServletException e) {
                this.writeException((Exception)((Object)e));
                throw e;
            }
            catch (IOException e) {
                this.writeException(e);
                throw e;
            }
            catch (Exception e) {
                this.writeException(e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String pathParam = filterConfig.getInitParameter("path");
        String debugParam = filterConfig.getInitParameter("level");
        String rotate = filterConfig.getInitParameter("rotate");
        String logMax = filterConfig.getInitParameter("logmax");
        String resultSize = filterConfig.getInitParameter("resultSize");
        if (debugParam != null) {
            this.debugMode = LogLevel.valueOf(debugParam.toLowerCase());
            if (this.debugMode.equals((Object)LogLevel.debug)) {
                this.targetLogs = Arrays.asList(this.debugLogs);
            }
            if (this.debugMode.equals((Object)LogLevel.full)) {
                this.targetLogs = Arrays.asList(this.fullLogs);
            }
            if (this.debugMode.equals((Object)LogLevel.middle)) {
                this.targetLogs = Arrays.asList(this.middleLogs);
            }
            if (this.debugMode.equals((Object)LogLevel.smart)) {
                this.targetLogs = Arrays.asList(this.smartLogs);
            }
        }
        if (this.debugMode == LogLevel.none) {
            return;
        }
        if (pathParam != null) {
            try {
                this.logDirPath = new File(pathParam);
                this.mkDir();
                if (!this.logDirPath.isDirectory()) {
                    this.logDirPath = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (rotate != null) {
            try {
                this.logRotate = Boolean.parseBoolean(rotate);
            }
            catch (Exception e) {
                this.logRotate = true;
            }
        }
        if (logMax != null) {
            try {
                this.maxGeneration = Integer.parseInt(logMax);
            }
            catch (Exception e) {
                this.maxGeneration = 7;
            }
        }
        if (resultSize != null) {
            try {
                this.responseLogMaxSize = Integer.parseInt(resultSize);
            }
            catch (Exception e) {
                this.responseLogMaxSize = 128;
            }
        }
    }

    private class LogFilenameFilter
    implements FilenameFilter {
        private LogFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.startsWith("filterlog_") && name.endsWith(".log");
        }
    }

    private class CachedServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private ServletOutputStream superOut = null;

        public CachedServletOutputStream(ServletOutputStream sos) {
            this.superOut = sos;
        }

        public void write(int b) throws IOException {
            this.baos.write(b);
            this.superOut.write(b);
        }

        public void write(char c) throws IOException {
            this.baos.write(String.valueOf(c).getBytes());
            this.superOut.write((int)c);
        }

        public void write(String s, int off, int len) throws IOException {
            int i = off;
            while (i < len) {
                this.write(s.charAt(i));
                ++i;
            }
        }

        public void write(char[] buf, int off, int len) throws IOException {
            int i = off;
            while (i < len) {
                this.write(buf[i]);
                ++i;
            }
        }

        public byte[] toByteArray() {
            return this.baos.toByteArray();
        }

        public void flush() throws IOException {
            this.superOut.flush();
        }
    }

    private class DebuglogResponseWrapper
    extends HttpServletResponseWrapper {
        private HashMap<String, String> headerCache;
        private CachedServletOutputStream csos;
        private PrintWriter defaultWriter;
        private StringWriter sw;
        private PrintWriter pw;
        private HttpServletResponse response;
        private int statusCode;

        public DebuglogResponseWrapper(HttpServletResponse response) throws IOException {
            super(response);
            this.headerCache = new HashMap();
            this.csos = null;
            this.defaultWriter = null;
            this.sw = null;
            this.pw = null;
            this.response = null;
            this.statusCode = 200;
            this.response = response;
        }

        public void setStatus(int sc) {
            super.setStatus(sc);
            this.statusCode = sc;
        }

        public void setStatus(int sc, String sm) {
            super.setStatus(sc, sm);
            this.statusCode = sc;
        }

        public String getResult() {
            if (DebugLogFilter.this.responseLogMaxSize < 1) {
                if (this.csos == null) {
                    if (this.getWriterBuffer() == null) {
                        return "null";
                    }
                    return this.getWriterBuffer().toString();
                }
                return new String(this.csos.toByteArray());
            }
            int length = 0;
            if (this.csos == null) {
                if (this.getWriterBuffer() == null) {
                    return "null";
                }
                length = this.getWriterBuffer().toString().length() > DebugLogFilter.this.responseLogMaxSize ? DebugLogFilter.this.responseLogMaxSize : this.getWriterBuffer().toString().length();
                return this.getWriterBuffer().toString().substring(0, length);
            }
            length = this.csos.toByteArray().length > DebugLogFilter.this.responseLogMaxSize ? DebugLogFilter.this.responseLogMaxSize : this.csos.toByteArray().length;
            return new String(this.csos.toByteArray(), 0, length);
        }

        public void addDateHeader(String name, long date) {
            this.headerCache.put(name, String.valueOf(date));
            super.addDateHeader(name, date);
        }

        public void addHeader(String name, String value) {
            this.headerCache.put(name, value);
            super.addHeader(name, value);
        }

        public void addIntHeader(String name, int value) {
            this.headerCache.put(name, String.valueOf(value));
            super.addIntHeader(name, value);
        }

        public void setDateHeader(String name, long date) {
            this.headerCache.put(name, String.valueOf(date));
            super.setDateHeader(name, date);
        }

        public void setHeader(String name, String value) {
            this.headerCache.put(name, value);
            super.setHeader(name, value);
        }

        public void setIntHeader(String name, int value) {
            this.headerCache.put(name, String.valueOf(value));
            super.setIntHeader(name, value);
        }

        public String toString() {
            StringBuffer result = new StringBuffer("{");
            Iterator<String> it = this.headerCache.keySet().iterator();
            result.append("[RESULT_CODE=");
            result.append(String.valueOf(this.statusCode) + "]");
            if (it.hasNext()) {
                result.append(",");
            }
            while (it.hasNext()) {
                String key = it.next();
                String val = this.headerCache.get(key);
                result.append("[" + key);
                result.append("=");
                result.append(String.valueOf(val) + "]");
                if (!it.hasNext()) continue;
                result.append(",");
            }
            result.append("}");
            return result.toString();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (DebugLogFilter.this.debugMode != LogLevel.debug) {
                return this.response.getOutputStream();
            }
            this.csos = new CachedServletOutputStream(this.response.getOutputStream());
            return this.csos;
        }

        public void writerFlush() throws IOException {
            if (DebugLogFilter.this.debugMode != LogLevel.debug) {
                this.response.flushBuffer();
            } else if (this.pw != null && this.sw != null) {
                this.pw.flush();
                this.defaultWriter.write(this.getWriterBuffer().toString());
                this.defaultWriter.flush();
            }
        }

        public StringBuffer getWriterBuffer() {
            if (this.sw != null) {
                return this.sw.getBuffer();
            }
            return null;
        }

        public PrintWriter getWriter() throws IOException {
            if (DebugLogFilter.this.debugMode != LogLevel.debug) {
                return this.response.getWriter();
            }
            if (this.sw == null && this.pw == null) {
                this.sw = new StringWriter();
                this.pw = new PrintWriter(this.sw);
                this.defaultWriter = this.response.getWriter();
            }
            return this.pw;
        }
    }
}

