/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.scriptlet;

import info.dragonlady.scriptlet.IllegalAccessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class SecureServlet
extends HttpServlet {
    private static final long serialVersionUID = -1783518376805871958L;
    private static final String DEFAULT_CHARSET = "Shift-jis";
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private HttpSession session = null;
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private String SCRIPTLET_PATH = "scriptlet_path";
    protected static final String SEQUENCE_KEY = "info.dragonlady.scriptlet.SecureServlet#SEQUENCE_KEY";
    protected int sequenceId = 0;
    protected String charset = "Shift-jis";
    protected String scriptletPath = "WEB-INF" + File.separator + "scriptlet" + File.separator;
    private Properties properties = new Properties();
    public static final int INIT_SEQUENCE = 0;
    public static final int EXEC_SEQUENCE = 1;
    public static final int INVALID_SEQUENCE = 99;

    public abstract long getSerialVersionUID();

    protected void initialize() throws IllegalAccessException {
        this.sequenceId = this.verifySequence();
        if (this.sequenceId == 99) {
            this.session.setAttribute(SEQUENCE_KEY, null);
            throw new IllegalAccessException("Invalid sequence detected.");
        }
    }

    protected final void service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            this.session = req.getSession();
            this.request = req;
            this.response = res;
            String paramPath = String.valueOf(this.getServletContext().getRealPath("/")) + "WEB-INF" + File.separator + "config.xml";
            this.properties.loadFromXML(new FileInputStream(paramPath));
            this.initialize();
            super.service(req, res);
            res.setContentType(this.getContentTypeValue());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace(System.out);
            res.sendError(403, e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            res.sendError(404, e.getMessage());
        }
        catch (ServletException e) {
            e.printStackTrace(System.out);
            res.sendError(404, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            res.sendError(404, e.getMessage());
        }
    }

    protected int verifySequence() {
        int result = 0;
        Object sessionSeqVal = this.session.getAttribute(SEQUENCE_KEY);
        String pathName = this.request.getRequestURL().toString();
        pathName = pathName.startsWith("/") ? pathName.substring(1) : pathName;
        String svu = Long.toString(this.getSerialVersionUID());
        if (sessionSeqVal != null) {
            result = sessionSeqVal.equals(this.getInitSequence()) ? 0 : (sessionSeqVal.equals(String.valueOf(pathName) + svu) ? (this.isExecSequence() ? 1 : 0) : this.getDefaultSequence());
        } else if (this.getInitSequence() != sessionSeqVal) {
            result = 99;
        }
        return result;
    }

    protected boolean isExecSequence() {
        return !this.request.getParameterMap().isEmpty();
    }

    protected void setSequence() {
        String pathName = this.request.getRequestURL().toString();
        pathName = pathName.startsWith("/") ? pathName.substring(1) : pathName;
        String svu = Long.toString(this.getSerialVersionUID());
        if (this.isExecute()) {
            this.session.setAttribute(SEQUENCE_KEY, (Object)this.getNextInitSequence());
        } else {
            this.session.setAttribute(SEQUENCE_KEY, (Object)(String.valueOf(pathName) + svu));
        }
    }

    protected String getSequence() {
        return this.session.getAttribute(SEQUENCE_KEY) == null ? null : this.session.getAttribute(SEQUENCE_KEY).toString();
    }

    protected int getDefaultSequence() {
        return 0;
    }

    public boolean isExecute() {
        return this.sequenceId == 1;
    }

    public abstract String getNextInitSequence();

    public abstract String getInitSequence();

    public HttpSession getSession() {
        return this.session;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    protected String getCharSet() {
        return this.charset;
    }

    public void setCharSet(String code) {
        this.charset = code;
        this.response.setCharacterEncoding(this.charset);
    }

    public String getScriptletPath() {
        String path = String.valueOf(this.getServletContext().getRealPath("/")) + this.scriptletPath;
        if (this.properties.getProperty(this.SCRIPTLET_PATH) != null && this.properties.getProperty(this.SCRIPTLET_PATH).length() > 2 && !(path = this.properties.getProperty(this.SCRIPTLET_PATH)).endsWith(File.separator)) {
            path = String.valueOf(path) + File.separator;
        }
        return path;
    }

    protected String getContentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    private String getContentTypeValue() {
        return String.valueOf(this.getContentType()) + "; charset=" + this.getCharSet();
    }
}

