/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.implementations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.xml.security.c14n.implementations.NameSpaceSymbEntry;
import org.apache.xml.security.c14n.implementations.SymbMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class NameSpaceSymbTable {
    SymbMap symb = new SymbMap();
    int nameSpaces = 0;
    List level = new ArrayList();
    boolean cloned = true;
    static final String XMLNS = "xmlns";

    public NameSpaceSymbTable() {
        NameSpaceSymbEntry nameSpaceSymbEntry = new NameSpaceSymbEntry("", null, true);
        nameSpaceSymbEntry.lastrendered = "";
        this.symb.put(XMLNS, nameSpaceSymbEntry);
    }

    public void getUnrenderedNodes(Collection collection) {
        Iterator iterator = this.symb.entrySet().iterator();
        while (iterator.hasNext()) {
            NameSpaceSymbEntry nameSpaceSymbEntry = (NameSpaceSymbEntry)iterator.next();
            if (nameSpaceSymbEntry.rendered || nameSpaceSymbEntry.n == null) continue;
            collection.add(nameSpaceSymbEntry.n);
            nameSpaceSymbEntry.rendered = true;
        }
    }

    public void outputNodePush() {
        ++this.nameSpaces;
        this.push();
    }

    public void outputNodePop() {
        --this.nameSpaces;
        this.pop();
    }

    public void push() {
        this.level.add(null);
        this.cloned = false;
    }

    public void pop() {
        int n = this.level.size() - 1;
        Object e = this.level.remove(n);
        if (e != null) {
            this.symb = (SymbMap)e;
            this.cloned = n == 0 ? false : this.level.get(n - 1) != this.symb;
        } else {
            this.cloned = false;
        }
    }

    final void needsClone() {
        if (!this.cloned) {
            this.level.remove(this.level.size() - 1);
            this.level.add(this.symb);
            this.symb = (SymbMap)this.symb.clone();
            this.cloned = true;
        }
    }

    public Attr getMapping(String string) {
        NameSpaceSymbEntry nameSpaceSymbEntry = this.symb.get(string);
        if (nameSpaceSymbEntry == null) {
            return null;
        }
        if (nameSpaceSymbEntry.rendered) {
            return null;
        }
        nameSpaceSymbEntry = (NameSpaceSymbEntry)nameSpaceSymbEntry.clone();
        this.needsClone();
        this.symb.put(string, nameSpaceSymbEntry);
        nameSpaceSymbEntry.rendered = true;
        nameSpaceSymbEntry.level = this.nameSpaces;
        nameSpaceSymbEntry.lastrendered = nameSpaceSymbEntry.uri;
        return nameSpaceSymbEntry.n;
    }

    public Attr getMappingWithoutRendered(String string) {
        NameSpaceSymbEntry nameSpaceSymbEntry = this.symb.get(string);
        if (nameSpaceSymbEntry == null) {
            return null;
        }
        if (nameSpaceSymbEntry.rendered) {
            return null;
        }
        return nameSpaceSymbEntry.n;
    }

    public boolean addMapping(String string, String string2, Attr attr) {
        NameSpaceSymbEntry nameSpaceSymbEntry = this.symb.get(string);
        if (nameSpaceSymbEntry != null && string2.equals(nameSpaceSymbEntry.uri)) {
            return false;
        }
        NameSpaceSymbEntry nameSpaceSymbEntry2 = new NameSpaceSymbEntry(string2, attr, false);
        this.needsClone();
        this.symb.put(string, nameSpaceSymbEntry2);
        if (nameSpaceSymbEntry != null) {
            nameSpaceSymbEntry2.lastrendered = nameSpaceSymbEntry.lastrendered;
            if (nameSpaceSymbEntry.lastrendered != null && nameSpaceSymbEntry.lastrendered.equals(string2)) {
                nameSpaceSymbEntry2.rendered = true;
            }
        }
        return true;
    }

    public Node addMappingAndRender(String string, String string2, Attr attr) {
        NameSpaceSymbEntry nameSpaceSymbEntry = this.symb.get(string);
        if (nameSpaceSymbEntry != null && string2.equals(nameSpaceSymbEntry.uri)) {
            if (!nameSpaceSymbEntry.rendered) {
                nameSpaceSymbEntry = (NameSpaceSymbEntry)nameSpaceSymbEntry.clone();
                this.needsClone();
                this.symb.put(string, nameSpaceSymbEntry);
                nameSpaceSymbEntry.lastrendered = string2;
                nameSpaceSymbEntry.rendered = true;
                return nameSpaceSymbEntry.n;
            }
            return null;
        }
        NameSpaceSymbEntry nameSpaceSymbEntry2 = new NameSpaceSymbEntry(string2, attr, true);
        nameSpaceSymbEntry2.lastrendered = string2;
        this.needsClone();
        this.symb.put(string, nameSpaceSymbEntry2);
        if (nameSpaceSymbEntry != null && nameSpaceSymbEntry.lastrendered != null && nameSpaceSymbEntry.lastrendered.equals(string2)) {
            nameSpaceSymbEntry2.rendered = true;
            return null;
        }
        return nameSpaceSymbEntry2.n;
    }

    public Node addMappingAndRenderXNodeSet(String string, String string2, Attr attr, boolean bl) {
        NameSpaceSymbEntry nameSpaceSymbEntry = this.symb.get(string);
        int n = this.nameSpaces;
        if (nameSpaceSymbEntry != null && string2.equals(nameSpaceSymbEntry.uri)) {
            if (!nameSpaceSymbEntry.rendered) {
                nameSpaceSymbEntry = (NameSpaceSymbEntry)nameSpaceSymbEntry.clone();
                this.needsClone();
                this.symb.put(string, nameSpaceSymbEntry);
                nameSpaceSymbEntry.rendered = true;
                nameSpaceSymbEntry.level = n;
                return nameSpaceSymbEntry.n;
            }
            nameSpaceSymbEntry = (NameSpaceSymbEntry)nameSpaceSymbEntry.clone();
            this.needsClone();
            this.symb.put(string, nameSpaceSymbEntry);
            if (bl && (n - nameSpaceSymbEntry.level < 2 || XMLNS.equals(string))) {
                nameSpaceSymbEntry.level = n;
                return null;
            }
            nameSpaceSymbEntry.level = n;
            return nameSpaceSymbEntry.n;
        }
        NameSpaceSymbEntry nameSpaceSymbEntry2 = new NameSpaceSymbEntry(string2, attr, true);
        nameSpaceSymbEntry2.level = this.nameSpaces;
        nameSpaceSymbEntry2.rendered = true;
        this.needsClone();
        this.symb.put(string, nameSpaceSymbEntry2);
        if (nameSpaceSymbEntry != null) {
            nameSpaceSymbEntry2.lastrendered = nameSpaceSymbEntry.lastrendered;
            if (nameSpaceSymbEntry.lastrendered != null && nameSpaceSymbEntry.lastrendered.equals(string2)) {
                nameSpaceSymbEntry2.rendered = true;
            }
        }
        return nameSpaceSymbEntry2.n;
    }
}

