/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.util;

import info.dragonlady.util.MimeType;
import info.dragonlady.util.SmtpException;
import info.dragonlady.util.schema.annotation.GPS;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmtpParser {
    protected static final String receivedHeader = "Received:";
    protected static final String fromHeader = "From:";
    protected static final String toHeader = "To:";
    protected static final String subjetHeader = "Subject:";
    protected static final String dateHeader = "Date:";
    protected static final String binaryEncodeHeader = "[Cc]ontent-[Tt]ransfer-[Ee]ncoding:";
    protected static final String delimiterRegEx1 = "^[Cc]ontent-[Tt]ype:.*[Mm]ultipart/[Mm]ixed.*";
    protected static final String delimiterRegEx2 = ".+[Bb]oundary=(.+)";
    protected static final String charsetRegEx = "^[Cc]ontent-[Tt]ype:\\s*text/plain.+[Cc]harset=(.+)";
    protected static final String mimeTypeRegEx = "^[Cc]ontent-[Tt]ype:\\s*(.+);.*";
    protected static final String fileNameRegEx = ".+[Nn]ame=(.+).*";
    protected static final Dimension QVGDimension = new Dimension(240, 320);
    protected static final double defualtResizePercent = 0.75;
    protected String receivedHeaderValue = "";
    protected String fromHeaderValue = "";
    protected String toHeaderValue = "";
    protected String subjectHeaderValue = "";
    protected String binaryEncoderHeaderValue = "";
    protected String delimiterValue = "";
    protected String charsetValue = "";
    protected String fileNameValue = "";
    protected String bodyValue = "";
    protected String defaultSubject = "";
    protected Calendar contributeDate = null;
    protected Vector<ByteImage> imageBuffer = new Vector();
    protected boolean reduceImage = false;
    protected boolean removeTransparency = false;
    protected Properties properties = new Properties();
    protected MimeType mt;
    protected boolean startSubject = false;
    protected boolean startFromAddr = false;

    protected SmtpParser(Properties prop, Vector<String> mimeList) throws SmtpException {
        try {
            this.properties = prop;
            this.defaultSubject = this.properties.getProperty("default_subject");
            this.mt = MimeType.getMimeType(mimeList);
        }
        catch (Exception e) {
            throw new SmtpException(e);
        }
    }

    public static SmtpParser parse(String smtpData, Properties prop, Vector<String> mimeList) throws UnsupportedEncodingException, IOException, SmtpException, ParseException {
        SmtpParser smtp = new SmtpParser(prop, mimeList);
        String[] splitSmtpData = smtpData.indexOf("\r") >= 0 ? smtpData.replaceAll("\\r", "").split("[\n]") : smtpData.split("[\n]");
        smtp.setReceiveAddr(splitSmtpData);
        smtp.setFromAddr(splitSmtpData);
        smtp.setToAddr(splitSmtpData);
        smtp.setSubject(splitSmtpData);
        smtp.setDate(splitSmtpData);
        smtp.setBody(smtp.divideData(splitSmtpData));
        smtp.setImage(smtp.divideData(splitSmtpData));
        return smtp;
    }

    public static SmtpParser parse(String smtpData, boolean removeTranceparency, boolean reduceImage, Properties prop, Vector<String> mimeList) throws UnsupportedEncodingException, IOException, SmtpException, ParseException {
        SmtpParser smtp = new SmtpParser(prop, mimeList);
        smtp.removeTransparency = removeTranceparency;
        smtp.reduceImage = reduceImage;
        String[] splitSmtpData = smtpData.indexOf("\r") >= 0 ? smtpData.replaceAll("\\r", "").split("[\n]") : smtpData.split("[\n]");
        smtp.setReceiveAddr(splitSmtpData);
        smtp.setFromAddr(splitSmtpData);
        smtp.setToAddr(splitSmtpData);
        smtp.setSubject(splitSmtpData);
        smtp.setDate(splitSmtpData);
        smtp.setBody(smtp.divideData(splitSmtpData));
        smtp.setImage(smtp.divideData(splitSmtpData));
        return smtp;
    }

    protected void checkBodyLength(String body) throws SmtpException {
        int maxLength = Integer.parseInt(this.properties.getProperty("maxbody"));
        if (body.length() > maxLength) {
            throw new SmtpException("Message body too large.");
        }
    }

    protected void checkMailServer(String serverAddr) throws SmtpException {
        String whiteServers = this.properties.getProperty("white-servers");
        if (whiteServers != null && whiteServers.length() > 0) {
            String[] serverList;
            String[] stringArray = serverList = whiteServers.split(",");
            int n = serverList.length;
            int n2 = 0;
            while (n2 < n) {
                int index;
                String receivedHeaderOther;
                String server = stringArray[n2];
                if (serverAddr.toLowerCase().indexOf(server) >= 0 && (receivedHeaderOther = serverAddr.substring(index = serverAddr.toLowerCase().indexOf(server) + server.length())).startsWith(" ")) {
                    return;
                }
                ++n2;
            }
        }
        throw new SmtpException("Illegal server access.");
    }

    protected void setReceiveAddr(String[] smtpData) throws SmtpException {
        String[] stringArray = smtpData;
        int n = smtpData.length;
        int n2 = 0;
        while (n2 < n) {
            String data = stringArray[n2];
            if (data.startsWith(receivedHeader)) {
                this.receivedHeaderValue = data.substring(receivedHeader.length()).trim();
                this.checkMailServer(this.receivedHeaderValue);
                break;
            }
            ++n2;
        }
    }

    protected void setFromAddr(String[] smtpData) {
        String[] stringArray = smtpData;
        int n = smtpData.length;
        int n2 = 0;
        while (n2 < n) {
            String data = stringArray[n2];
            if (!data.startsWith(fromHeader) && data.matches(".+:\\s*.+")) {
                if (this.startFromAddr) {
                    this.startFromAddr = false;
                    break;
                }
                this.startFromAddr = false;
            }
            if (data.startsWith(fromHeader) || this.startFromAddr) {
                this.fromHeaderValue = this.startFromAddr ? data.trim() : data.substring(fromHeader.length()).trim();
                this.startFromAddr = true;
                if (this.fromHeaderValue.indexOf("<") >= 0 && this.fromHeaderValue.indexOf(">") > 0) {
                    this.fromHeaderValue = this.fromHeaderValue.substring(this.fromHeaderValue.indexOf("<") + 1, this.fromHeaderValue.indexOf(">"));
                }
            }
            ++n2;
        }
    }

    protected void setToAddr(String[] smtpData) {
        String[] stringArray = smtpData;
        int n = smtpData.length;
        int n2 = 0;
        while (n2 < n) {
            String data = stringArray[n2];
            if (data.startsWith(toHeader)) {
                this.toHeaderValue = data.substring(toHeader.length()).trim();
                if (this.toHeaderValue.indexOf("<") < 0 || this.toHeaderValue.indexOf(">") <= 0) break;
                this.toHeaderValue = this.toHeaderValue.substring(this.toHeaderValue.indexOf("<") + 1, this.toHeaderValue.indexOf(">"));
                break;
            }
            ++n2;
        }
    }

    protected void setSubject(String[] smtpData) throws UnsupportedEncodingException {
        String[] stringArray = smtpData;
        int n = smtpData.length;
        int n2 = 0;
        while (n2 < n) {
            String data = stringArray[n2];
            if (data.startsWith(subjetHeader) || this.startSubject) {
                String subjectValue = this.startSubject ? data.trim() : data.substring(subjetHeader.length()).trim();
                this.startSubject = true;
                if (subjectValue.toLowerCase().indexOf("iso-2022-jp") >= 0) {
                    Matcher m = Pattern.compile("(.+)B\\?(.+)\\?(.*)").matcher(subjectValue);
                    if (m.matches()) {
                        String a = m.group(1) == null ? new String() : m.group(1);
                        String b = m.group(3) == null ? new String() : m.group(3);
                        a = a.indexOf("=?") > 0 ? a.substring(0, a.indexOf("=?")) : new String();
                        b = b.length() > 1 ? b.substring(1) : new String();
                        byte[] decode = Base64.decodeBase64((byte[])m.group(2).getBytes());
                        this.subjectHeaderValue = String.valueOf(this.subjectHeaderValue) + a + new String(decode, "ISO-2022-JP") + b;
                    }
                } else if (data.startsWith(subjetHeader)) {
                    this.subjectHeaderValue = String.valueOf(this.subjectHeaderValue) + subjectValue;
                } else if (!data.matches(".+:\\s*.+")) {
                    this.subjectHeaderValue = String.valueOf(this.subjectHeaderValue) + subjectValue;
                }
            }
            if (!data.startsWith(subjetHeader) && data.matches(".+:\\s*.+")) {
                if (this.startSubject) {
                    this.startSubject = false;
                    break;
                }
                this.startSubject = false;
            }
            ++n2;
        }
    }

    protected void setDate(String[] smtpData) throws ParseException {
        String[] stringArray = smtpData;
        int n = smtpData.length;
        int n2 = 0;
        while (n2 < n) {
            String data = stringArray[n2];
            if (data.startsWith(dateHeader)) {
                String dateStr = data.substring(dateHeader.length()).trim();
                SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
                this.contributeDate = Calendar.getInstance();
                this.contributeDate.setTime(sdf.parse(dateStr, new ParsePosition(0)));
            }
            ++n2;
        }
    }

    protected Vector<String> divideData(String[] smtpData) {
        Vector<String> result = new Vector<String>();
        StringBuffer tempData = new StringBuffer();
        boolean startFlg = false;
        int i = 0;
        while (i < smtpData.length) {
            String data = smtpData[i];
            if (startFlg) {
                tempData.append(String.valueOf(data) + "\n");
            }
            if (data.matches(delimiterRegEx1)) {
                return this.divideMultipartData(smtpData, i);
            }
            if (data.length() < 1) {
                startFlg = true;
            }
            ++i;
        }
        result.add(tempData.toString());
        return result;
    }

    protected Vector<String> divideMultipartData(String[] smtpData, int index) {
        Vector<String> result = new Vector<String>();
        StringBuffer tempData = new StringBuffer();
        boolean startFlg = false;
        int offset = 1;
        String delimiter = smtpData[index];
        int i = index;
        while (i < smtpData.length) {
            Matcher m = Pattern.compile(delimiterRegEx2).matcher(smtpData[i]);
            if (m.matches()) {
                delimiter = m.group(1);
                if (delimiter.startsWith("\"")) {
                    delimiter = delimiter.substring(1);
                }
                if (delimiter.endsWith("\"")) {
                    delimiter = delimiter.substring(0, delimiter.length() - 1);
                }
                offset += i;
                break;
            }
            ++i;
        }
        i = offset;
        while (i < smtpData.length) {
            if (startFlg && !smtpData[i].startsWith("--" + delimiter)) {
                tempData.append(String.valueOf(smtpData[i]) + "\n");
            }
            if (smtpData[i].startsWith("--" + delimiter)) {
                if (startFlg) {
                    result.add(tempData.toString());
                    tempData = new StringBuffer();
                } else {
                    startFlg = true;
                }
            }
            ++i;
        }
        return result;
    }

    protected void setBody(Vector<String> partData) throws SmtpException {
        boolean startFlg = false;
        StringBuffer tempData = new StringBuffer();
        String mimeType = "nomime";
        for (String parts : partData) {
            String[] splitData = parts.split("\n");
            int i = 0;
            while (i < splitData.length) {
                Matcher m;
                String data = splitData[i];
                if (startFlg) {
                    tempData.append(String.valueOf(data) + "\n");
                }
                if (data.length() < 1) {
                    startFlg = true;
                }
                if (data.matches(mimeTypeRegEx) && (m = Pattern.compile(mimeTypeRegEx).matcher(data)).matches()) {
                    mimeType = m.group(1).trim();
                    mimeType = mimeType.substring(mimeType.lastIndexOf("/") + 1);
                }
                ++i;
            }
            if (mimeType.toLowerCase().indexOf("plain") >= 0) {
                this.bodyValue = String.valueOf(this.bodyValue) + tempData.toString();
                this.checkBodyLength(this.bodyValue);
            } else if (mimeType.toLowerCase().indexOf("nomime") >= 0) {
                this.bodyValue = String.valueOf(this.bodyValue) + parts;
                this.checkBodyLength(this.bodyValue);
            }
            startFlg = false;
            tempData = new StringBuffer();
        }
    }

    protected void setImage(Vector<String> partData) throws IOException, SmtpException {
        boolean startFlg = false;
        StringBuffer tempData = new StringBuffer();
        String mimeType = "plain";
        for (String parts : partData) {
            String[] splitData = parts.split("\n");
            int i = 0;
            while (i < splitData.length) {
                Matcher m;
                String data = splitData[i];
                if (startFlg) {
                    tempData.append(String.valueOf(data) + "\n");
                }
                if (data.length() < 1) {
                    startFlg = true;
                }
                if (data.matches(mimeTypeRegEx) && (m = Pattern.compile(mimeTypeRegEx).matcher(data)).matches()) {
                    mimeType = m.group(1).trim();
                }
                if (data.matches(fileNameRegEx) && (m = Pattern.compile(fileNameRegEx).matcher(data)).matches()) {
                    this.fileNameValue = m.group(1).trim();
                    if (this.fileNameValue.startsWith("\"")) {
                        this.fileNameValue = this.fileNameValue.substring(1);
                    }
                    if (this.fileNameValue.endsWith("\"")) {
                        this.fileNameValue = this.fileNameValue.substring(0, this.fileNameValue.length() - 1);
                    }
                }
                ++i;
            }
            if (mimeType.toLowerCase().indexOf("plain") < 0 && mimeType.toLowerCase().indexOf("html") < 0 && this.mt.isBinalyData(mimeType)) {
                byte[] imageValue = Base64.decodeBase64((byte[])tempData.toString().getBytes());
                ByteImage byteImage = new ByteImage(mimeType, imageValue);
                this.imageBuffer.add(byteImage);
            }
            startFlg = false;
            tempData = new StringBuffer();
        }
    }

    public BufferedImage checkDimension(BufferedImage bim) {
        double width = bim.getWidth();
        double height = bim.getHeight();
        double safeWidth = (double)SmtpParser.QVGDimension.width * 0.75;
        double safeHeight = (double)SmtpParser.QVGDimension.height * 0.75;
        if (width > safeWidth || height > safeHeight) {
            double withRatio = safeWidth / width;
            double heightRatio = safeHeight / height;
            if (withRatio > heightRatio && withRatio < 0.0) {
                width *= withRatio;
                height *= withRatio;
            } else if (heightRatio > withRatio && heightRatio < 0.0) {
                width *= heightRatio;
                height *= heightRatio;
            } else if (heightRatio == height) {
                width *= withRatio;
                height *= heightRatio;
            } else if (withRatio < 1.0) {
                width *= withRatio;
                height *= withRatio;
            } else if (heightRatio < 1.0) {
                width *= heightRatio;
                height *= heightRatio;
            } else {
                width *= withRatio;
                height *= heightRatio;
            }
            BufferedImage newImage = null;
            newImage = bim.getColorModel() instanceof IndexColorModel ? new BufferedImage((int)width, (int)height, bim.getType(), (IndexColorModel)bim.getColorModel()) : new BufferedImage((int)width, (int)height, 1);
            Image newScaleImg = bim.getScaledInstance((int)width, (int)height, 4);
            newImage.getGraphics().drawImage(newScaleImg, 0, 0, null);
            return newImage;
        }
        return bim;
    }

    public BufferedImage checkTransparency(BufferedImage bim) {
        ColorModel cm = bim.getColorModel();
        int transparency = cm.getTransparency();
        int componentsNum = cm.getNumComponents();
        if (transparency == 2 && componentsNum == 4 && cm instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)cm;
            int pixLen = icm.getMapSize();
            int pixSize = icm.getPixelSize();
            byte[] reds = new byte[pixLen];
            byte[] greens = new byte[pixLen];
            byte[] blues = new byte[pixLen];
            icm.getBlues(blues);
            icm.getGreens(greens);
            icm.getReds(reds);
            int transPixel = icm.getTransparentPixel();
            blues[transPixel] = -1;
            greens[transPixel] = -1;
            reds[transPixel] = -1;
            int width = bim.getWidth();
            int height = bim.getHeight();
            int imageType = bim.getType();
            IndexColorModel icmOpaq = new IndexColorModel(pixSize, pixLen, reds, greens, blues);
            BufferedImage OpaqBim = new BufferedImage(width, height, imageType, icmOpaq);
            if (transPixel > 0) {
                int transRGB = icm.getRGB(transPixel);
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        if (bim.getRGB(x, y) == transRGB) {
                            OpaqBim.setRGB(x, y, -1);
                        } else {
                            OpaqBim.setRGB(x, y, bim.getRGB(x, y));
                        }
                        ++x;
                    }
                    ++y;
                }
            }
            return OpaqBim;
        }
        return bim;
    }

    public String getReceivedAddr() {
        return this.receivedHeaderValue;
    }

    public String getToAddr() {
        return this.toHeaderValue;
    }

    public String getFromAddr() {
        return this.fromHeaderValue;
    }

    public String getSubject() {
        if (this.subjectHeaderValue == null || this.subjectHeaderValue.length() < 1) {
            this.subjectHeaderValue = this.defaultSubject;
        }
        return this.subjectHeaderValue;
    }

    public HashMap<String, String> getSubjectParam() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.subjectHeaderValue.indexOf("_") >= 0 && this.subjectHeaderValue.indexOf("-") >= 0) {
            String[] stringArray = this.subjectHeaderValue.split("_");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                String key = param.substring(0, param.indexOf("-"));
                String value = param.substring(param.indexOf("-") + 1);
                result.put(key, value);
                ++n2;
            }
        } else if (this.subjectHeaderValue.indexOf("-") >= 0) {
            String key = this.subjectHeaderValue.substring(0, this.subjectHeaderValue.indexOf("-"));
            String value = this.subjectHeaderValue.substring(this.subjectHeaderValue.indexOf("-") + 1);
            result.put(key, value);
        }
        return result;
    }

    public String getBody() {
        if (this.bodyValue != null && this.bodyValue.length() > 0 && this.bodyValue.charAt(this.bodyValue.length() - 1) == '\n') {
            this.bodyValue = this.bodyValue.substring(0, this.bodyValue.length() - 1);
        }
        return this.bodyValue;
    }

    public void setBody(String body) {
        this.bodyValue = body;
    }

    public ByteImage getImage(int index) {
        return this.imageBuffer.get(index);
    }

    public Vector<ByteImage> getImages() {
        return this.imageBuffer;
    }

    public Calendar getContributeDate() {
        return this.contributeDate;
    }

    public class ByteImage {
        private byte[] jpegSOI = new byte[]{-1, -40};
        private byte[] takePictDateTag = new byte[]{-112, 3};
        private Byte[] SOI = new Byte[2];
        private Byte[] APP1Marker = new Byte[2];
        private Byte[] sizeOfAPP1 = new Byte[2];
        private Byte[] exifHeader = new Byte[6];
        private Byte[] tiffHeader = new Byte[8];
        private Byte[] numIFD0 = new Byte[2];
        private int numberOfEntryInIFD0 = 0;
        private int offsetOfTiffHeader = this.SOI.length + this.APP1Marker.length + this.sizeOfAPP1.length + this.exifHeader.length;
        private int lengthOfIFDEntry = 12;
        private String byteAlignTypeM = "MM";
        private String byteAlignTypeI = "II";
        private String exitDefinition = "Exif";
        protected EXIF_TYPE exifType = null;
        protected String mimeType = "unknown";
        protected String fileExtName = "jpg";
        protected Byte[] image = new Byte[1];
        protected String ExifGPS = null;
        protected Date takePictDate = null;
        protected boolean hasExif = false;

        public ByteImage(String mime, byte[] data) throws SmtpException {
            if (mime != null && mime.length() > 0) {
                this.mimeType = mime;
            }
            this.fileExtName = this.mimeType.indexOf("/") > 0 ? SmtpParser.this.mt.getExtendNameFromMimeType(this.mimeType) : SmtpParser.this.mt.getExtendNameFromMimeSubType(this.mimeType)[0];
            Vector<Byte> byteArray = new Vector<Byte>();
            int i = 0;
            while (i < data.length) {
                byteArray.add(data[i]);
                ++i;
            }
            this.image = byteArray.toArray(this.image);
            if (this.fileExtName.equals("jpg")) {
                this.checkExif();
            }
        }

        private void checkExif() throws SmtpException {
            try {
                int srcPos = 0;
                System.arraycopy(this.image, srcPos, this.SOI, 0, this.SOI.length);
                srcPos += this.SOI.length;
                if (this.checkSOI()) {
                    System.arraycopy(this.image, srcPos, this.APP1Marker, 0, this.APP1Marker.length);
                    System.arraycopy(this.image, srcPos += this.APP1Marker.length, this.sizeOfAPP1, 0, this.sizeOfAPP1.length);
                    System.arraycopy(this.image, srcPos += this.sizeOfAPP1.length, this.exifHeader, 0, this.exifHeader.length);
                    srcPos += this.exifHeader.length;
                    if (this.checkExifHeader()) {
                        System.arraycopy(this.image, srcPos, this.tiffHeader, 0, this.tiffHeader.length);
                        srcPos += this.tiffHeader.length;
                        if (this.checkTiffHeader()) {
                            System.arraycopy(this.image, srcPos, this.numIFD0, 0, this.numIFD0.length);
                            srcPos += this.numIFD0.length;
                            this.numberOfEntryInIFD0 = this.byte2Int(this.numIFD0);
                            int i = 0;
                            while (i < this.numberOfEntryInIFD0) {
                                Byte[] ifd = new Byte[this.lengthOfIFDEntry];
                                System.arraycopy(this.image, srcPos + this.lengthOfIFDEntry * i, ifd, 0, this.lengthOfIFDEntry);
                                EntryOfIFD ifdEntry = new EntryOfIFD(ifd, this.exifType);
                                if (ifdEntry.isGPSIFD0()) {
                                    this.ExifGPS = this.createGPSXML(ifdEntry.data);
                                }
                                if (ifdEntry.isSubIFD0()) {
                                    this.takePictDate = this.getPhotoDate(ifdEntry.data);
                                }
                                ++i;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new SmtpException(e);
            }
        }

        private boolean checkSOI() {
            return this.SOI[0] == this.jpegSOI[0] && this.SOI[1] == this.jpegSOI[1];
        }

        private boolean checkExifHeader() {
            byte[] temp = new byte[]{this.exifHeader[0], this.exifHeader[1], this.exifHeader[2], this.exifHeader[3]};
            String exif = new String(temp, 0, 4);
            return exif.toLowerCase().equals(this.exitDefinition.toLowerCase());
        }

        private boolean checkTiffHeader() {
            boolean result = false;
            byte[] temp = new byte[]{this.tiffHeader[0], this.tiffHeader[1]};
            String align = new String(temp, 0, 2);
            if (align.toLowerCase().equals(this.byteAlignTypeM.toLowerCase())) {
                this.exifType = EXIF_TYPE.MOTOROLA;
                result = true;
            } else if (align.toLowerCase().equals(this.byteAlignTypeI.toLowerCase())) {
                this.exifType = EXIF_TYPE.INTEL;
                result = true;
            }
            return result;
        }

        private String createGPSXML(Byte[] ifdOffset) throws JAXBException {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GPS.class});
            GPS gpsBean = new GPS();
            int offset = this.byte2Int(ifdOffset) + this.offsetOfTiffHeader;
            Byte[] GPSIFD = new Byte[2];
            System.arraycopy(this.image, offset, GPSIFD, 0, GPSIFD.length);
            int numberOfGPSIFDEntry = this.byte2Int(GPSIFD);
            offset += GPSIFD.length;
            GPS.Latitude latitudeBean = new GPS.Latitude();
            GPS.Longitude longitudeBean = new GPS.Longitude();
            GPS.Datum datumBean = new GPS.Datum();
            int i = 0;
            while (i < numberOfGPSIFDEntry) {
                Byte[] ifd = new Byte[this.lengthOfIFDEntry];
                System.arraycopy(this.image, offset + this.lengthOfIFDEntry * i, ifd, 0, this.lengthOfIFDEntry);
                EntryOfIFD ifdEntry = new EntryOfIFD(ifd, this.exifType);
                int tag = this.byte2Int(ifdEntry.tag);
                switch (tag) {
                    case 0: {
                        gpsBean.setVersion(String.format("%d.%d.%d.%d", ifdEntry.data[0] & 0xFF, ifdEntry.data[1] & 0xFF, ifdEntry.data[2] & 0xFF, ifdEntry.data[3] & 0xFF));
                        break;
                    }
                    case 1: {
                        latitudeBean.setRef(String.format("%c", ifdEntry.data[0]));
                        break;
                    }
                    case 2: {
                        int latitudeOffset = this.byte2Int(ifdEntry.data) + this.offsetOfTiffHeader;
                        Byte[] latitude = new Byte[24];
                        System.arraycopy(this.image, latitudeOffset, latitude, 0, latitude.length);
                        latitudeBean.setValue(this.calcCoordinate(latitude));
                        break;
                    }
                    case 3: {
                        longitudeBean.setRef(String.format("%c", ifdEntry.data[0]));
                        break;
                    }
                    case 4: {
                        int longitudeOffset = this.byte2Int(ifdEntry.data) + this.offsetOfTiffHeader;
                        Byte[] longitude = new Byte[24];
                        System.arraycopy(this.image, longitudeOffset, longitude, 0, longitude.length);
                        longitudeBean.setValue(this.calcCoordinate(longitude));
                        break;
                    }
                    case 18: {
                        int datumLength = this.byte2Int(ifdEntry.count);
                        int datumOffset = this.byte2Int(ifdEntry.data) + this.offsetOfTiffHeader;
                        Byte[] datum = new Byte[datumLength];
                        System.arraycopy(this.image, datumOffset, datum, 0, datumLength);
                        datumBean.setValue(this.byte2String(datum));
                    }
                }
                ++i;
            }
            gpsBean.setLatitude(latitudeBean);
            gpsBean.setLongitude(longitudeBean);
            gpsBean.setDatum(datumBean);
            Marshaller marshal = context.createMarshaller();
            StringWriter sw = new StringWriter();
            marshal.marshal((Object)gpsBean, (Writer)sw);
            return sw.toString();
        }

        private Date getPhotoDate(Byte[] dataOffset) throws ParseException {
            int offset = this.byte2Int(dataOffset) + this.offsetOfTiffHeader;
            Byte[] subIFD = new Byte[2];
            System.arraycopy(this.image, offset, subIFD, 0, subIFD.length);
            int numberOfSubIFDEntry = this.byte2Int(subIFD);
            offset += subIFD.length;
            int i = 0;
            while (i < numberOfSubIFDEntry) {
                Byte[] ifd = new Byte[this.lengthOfIFDEntry];
                System.arraycopy(this.image, offset + this.lengthOfIFDEntry * i, ifd, 0, this.lengthOfIFDEntry);
                EntryOfIFD ifdEntry = new EntryOfIFD(ifd, this.exifType);
                if (this.exifType == EXIF_TYPE.MOTOROLA && this.takePictDateTag[0] == ifdEntry.tag[0] && this.takePictDateTag[1] == ifdEntry.tag[1] || this.exifType == EXIF_TYPE.INTEL && this.takePictDateTag[0] == ifdEntry.tag[1] && this.takePictDateTag[1] == ifdEntry.tag[0]) {
                    int orignalPictDateLength = this.byte2Int(ifdEntry.count);
                    int orignalPictDateOffset = this.byte2Int(ifdEntry.data) + this.offsetOfTiffHeader;
                    Byte[] orignalPictDate = new Byte[orignalPictDateLength];
                    System.arraycopy(this.image, orignalPictDateOffset, orignalPictDate, 0, orignalPictDateLength);
                    String orignalPictDateStr = this.byte2String(orignalPictDate);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
                    return sdf.parse(orignalPictDateStr);
                }
                ++i;
            }
            return null;
        }

        private String byte2String(Byte[] args) {
            byte[] bytes = new byte[args.length];
            int actualLength = 0;
            int j = 0;
            while (j < args.length) {
                if (args[j] != 0) {
                    bytes[actualLength] = args[j];
                    ++actualLength;
                }
                ++j;
            }
            if (actualLength > 0) {
                return new String(bytes, 0, actualLength);
            }
            return new String();
        }

        private int byte2Int(Byte[] args) {
            int i;
            int result = 0;
            if (this.exifType == EXIF_TYPE.MOTOROLA) {
                i = 0;
                while (i < args.length) {
                    result = (int)((double)result + (double)(args[i] & 0xFF) * Math.pow(256.0, args.length - i - 1));
                    ++i;
                }
            }
            if (this.exifType == EXIF_TYPE.INTEL) {
                i = args.length - 1;
                while (i >= 0) {
                    result = (int)((double)result + (double)(args[i] & 0xFF) * Math.pow(256.0, i));
                    --i;
                }
            }
            return result;
        }

        private String calcCoordinate(Byte[] data) {
            Byte[] temp = new Byte[4];
            System.arraycopy(data, 0, temp, 0, temp.length);
            int numerator = this.byte2Int(temp);
            System.arraycopy(data, 4, temp, 0, temp.length);
            int denominator = this.byte2Int(temp);
            int degrees = numerator / denominator;
            System.arraycopy(data, 8, temp, 0, temp.length);
            numerator = this.byte2Int(temp);
            System.arraycopy(data, 12, temp, 0, temp.length);
            denominator = this.byte2Int(temp);
            int minutes = numerator / denominator;
            System.arraycopy(data, 16, temp, 0, temp.length);
            numerator = this.byte2Int(temp);
            System.arraycopy(data, 20, temp, 0, temp.length);
            denominator = this.byte2Int(temp);
            int seconds = numerator / denominator;
            return String.format("%d %d %d", degrees, minutes, seconds);
        }

        public boolean hasExif() {
            return this.hasExif;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getFileExtName() {
            return this.fileExtName;
        }

        public Byte[] getImage() {
            return this.image;
        }

        public byte[] getImagePrimitive() {
            byte[] result = new byte[this.image.length];
            int i = 0;
            while (i < this.image.length) {
                result[i] = this.image[i];
                ++i;
            }
            return result;
        }

        public String getExifGPSString() {
            return this.ExifGPS;
        }

        public Date getTakePictDate() {
            return this.takePictDate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum EXIF_TYPE {
        MOTOROLA,
        INTEL;

    }

    public class EntryOfIFD {
        protected byte[] subExifTag = new byte[]{-121, 105};
        protected byte[] GPSTag = new byte[]{-120, 37};
        protected byte[] OriginalDateTag = new byte[]{-112, 3};
        protected EXIF_TYPE exifType = null;
        public Byte[] tag = new Byte[2];
        public Byte[] format = new Byte[2];
        public Byte[] count = new Byte[4];
        public Byte[] data = new Byte[4];

        public EntryOfIFD(Byte[] ifddata, EXIF_TYPE type) {
            int srcPos = 0;
            this.exifType = type;
            System.arraycopy(ifddata, srcPos, this.tag, 0, this.tag.length);
            System.arraycopy(ifddata, srcPos += this.tag.length, this.format, 0, this.format.length);
            System.arraycopy(ifddata, srcPos += this.format.length, this.count, 0, this.count.length);
            System.arraycopy(ifddata, srcPos += this.count.length, this.data, 0, this.data.length);
            srcPos += this.data.length;
        }

        public boolean isGPSIFD0() {
            boolean result = false;
            if (this.exifType == EXIF_TYPE.MOTOROLA) {
                result = this.tag[0] == this.GPSTag[0] && this.tag[1] == this.GPSTag[1];
            } else if (this.exifType == EXIF_TYPE.INTEL) {
                result = this.tag[1] == this.GPSTag[0] && this.tag[0] == this.GPSTag[1];
            }
            return result;
        }

        public boolean isTakePictDateIFD0() {
            boolean result = false;
            if (this.exifType == EXIF_TYPE.MOTOROLA) {
                result = this.tag[0] == this.OriginalDateTag[0] && this.tag[1] == this.OriginalDateTag[1];
            } else if (this.exifType == EXIF_TYPE.INTEL) {
                result = this.tag[1] == this.OriginalDateTag[0] && this.tag[0] == this.OriginalDateTag[1];
            }
            return result;
        }

        public boolean isSubIFD0() {
            boolean result = false;
            if (this.exifType == EXIF_TYPE.MOTOROLA) {
                result = this.tag[0] == this.subExifTag[0] && this.tag[1] == this.subExifTag[1];
            } else if (this.exifType == EXIF_TYPE.INTEL) {
                result = this.tag[1] == this.subExifTag[0] && this.tag[0] == this.subExifTag[1];
            }
            return result;
        }
    }
}

