/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.cluster;

import info.dragonlady.cluster.Friend;
import info.dragonlady.cluster.UserService;
import info.dragonlady.cluster.UserServiceException;
import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.helper.LoginManager;
import info.dragonlady.sso.message.SSOMessageResource;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserServiceWrapper {
    public static final void add(String user, String relationId) throws UserServiceException {
        try {
            Friend[] friends = SSOConfig.getFriends();
            int i = 0;
            while (i < friends.length) {
                Object[] args = new String[]{friends[i].getHost(), friends[i].getPort()};
                try {
                    String name = SSOConfig.getServiceName(args[0], args[1], "UserService");
                    UserService service = (UserService)Naming.lookup(name);
                    if (service.add(user, relationId)) {
                        Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("6320", new Object[]{args, user, relationId}));
                    } else {
                        Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6301", args));
                    }
                }
                catch (ConnectException e) {
                    Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6302", args), (Throwable)e);
                }
                catch (NotBoundException e) {
                    Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6303", args), (Throwable)e);
                }
                catch (Exception e) {
                    Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6304", args), (Throwable)e);
                }
                ++i;
            }
        }
        catch (Exception e) {
            String message = SSOMessageResource.getMessage("6305");
            Logger.getRootLogger().error((Object)message, (Throwable)e);
            throw new UserServiceException(message, e);
        }
    }

    public static final void remove(String user) throws UserServiceException {
        try {
            Friend[] friends = SSOConfig.getFriends();
            int i = 0;
            while (i < friends.length) {
                Object[] args = new String[]{friends[i].getHost(), friends[i].getPort()};
                try {
                    String name = SSOConfig.getServiceName(args[0], args[1], "UserService");
                    UserService service = (UserService)Naming.lookup(name);
                    if (service.remove(user)) {
                        Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("6321", new Object[]{args, user}));
                    } else {
                        Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6306", args));
                    }
                }
                catch (ConnectException e) {
                    Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6307", args), (Throwable)e);
                }
                catch (NotBoundException e) {
                    Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6308", args), (Throwable)e);
                }
                catch (Exception e) {
                    Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6309", args), (Throwable)e);
                }
                ++i;
            }
        }
        catch (Exception e) {
            String message = SSOMessageResource.getMessage("6310");
            Logger.getRootLogger().error((Object)message, (Throwable)e);
            throw new UserServiceException(message, e);
        }
    }

    public static final void removeByRelationId(String relationId) throws UserServiceException {
        try {
            Friend[] friends = SSOConfig.getFriends();
            int i = 0;
            while (i < friends.length) {
                Object[] args = new String[]{friends[i].getHost(), friends[i].getPort()};
                try {
                    String name = SSOConfig.getServiceName(args[0], args[1], "UserService");
                    UserService service = (UserService)Naming.lookup(name);
                    if (service.removeByRelationId(relationId)) {
                        Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("6322", new Object[]{args, relationId}));
                    } else {
                        Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6311", args));
                    }
                }
                catch (ConnectException e) {
                    Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6312", args), (Throwable)e);
                }
                catch (NotBoundException e) {
                    Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6313", args), (Throwable)e);
                }
                catch (Exception e) {
                    Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6314", args), (Throwable)e);
                }
                ++i;
            }
        }
        catch (Exception e) {
            String message = SSOMessageResource.getMessage("6315");
            Logger.getRootLogger().error((Object)message, (Throwable)e);
            throw new UserServiceException(message, e);
        }
    }

    public static final void synchronize() throws UserServiceException {
        try {
            Friend[] friends = SSOConfig.getFriends();
            int i = 0;
            while (i < friends.length) {
                block7: {
                    Object[] args = new String[]{friends[i].getHost(), friends[i].getPort()};
                    try {
                        String name = SSOConfig.getServiceName(args[0], args[1], "UserService");
                        UserService service = (UserService)Naming.lookup(name);
                        Map<String, String> map = service.get();
                        if (map == null) break block7;
                        LoginManager lm = LoginManager.getInstance();
                        lm.setMap(map);
                        Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("6323", args));
                        break;
                    }
                    catch (ConnectException e) {
                        Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6316", args), (Throwable)e);
                    }
                    catch (NotBoundException e) {
                        Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6317", args), (Throwable)e);
                    }
                    catch (Exception e) {
                        Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6318", args), (Throwable)e);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            String message = SSOMessageResource.getMessage("6319");
            Logger.getRootLogger().error((Object)message, (Throwable)e);
            throw new UserServiceException(message, e);
        }
    }
}

