/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso.authority;

import info.dragonlady.sso.authority.AuthorityException;
import info.dragonlady.sso.authority.SAMLAuthority;
import info.dragonlady.sso.message.SSOMessageResource;
import info.dragonlady.sso.util.AssertionGenerator;
import info.dragonlady.sso.util.AssertionParser;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAuthorizationDecisionQuery;
import org.opensaml.SAMLException;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PolicyDecisionPoint
implements SAMLAuthority {
    @Override
    public final SAMLResponse query(SAMLRequest request) throws AuthorityException {
        try {
            SAMLResponse response = new SAMLResponse(request.getId(), null, null, null);
            SAMLException samlException = null;
            String authId = null;
            Map<String, List<String>> attributes = Collections.emptyMap();
            Iterator requestedAction = null;
            String resource = null;
            try {
                SAMLAuthorizationDecisionQuery query = (SAMLAuthorizationDecisionQuery)request.getQuery();
                Iterator evidence = query.getEvidence();
                while (evidence.hasNext()) {
                    AssertionParser parser = new AssertionParser((SAMLAssertion)evidence.next());
                    if (parser.containsAuthenticationStatement()) {
                        authId = parser.getName();
                    }
                    if (!parser.containsAttributeStatement()) continue;
                    attributes = parser.getAttribute();
                }
                requestedAction = query.getActions();
                resource = query.getResource();
            }
            catch (Exception e) {
                samlException = new SAMLException(SAMLException.REQUESTER, SSOMessageResource.getMessage("2201"), e);
            }
            if (samlException == null) {
                try {
                    List<SAMLAction> action = this.getPermittedAction(authId, attributes, resource);
                    String decision = this.decide(requestedAction, action);
                    SAMLAssertion assertion = AssertionGenerator.generateAuthorizationDecisionAssertion(authId, resource, decision, action);
                    response.addAssertion(assertion);
                    samlException = new SAMLException(SAMLException.SUCCESS);
                }
                catch (Exception e) {
                    samlException = new SAMLException(SAMLException.RESPONDER, SSOMessageResource.getMessage("2202"), e);
                }
            }
            response.setStatus(samlException);
            return response;
        }
        catch (Exception e) {
            throw new AuthorityException(SSOMessageResource.getMessage("2203"), e);
        }
    }

    private String decide(Iterator<SAMLAction> requestedAction, List<SAMLAction> permittedAction) {
        String decision = "Deny";
        int countTrue = 0;
        int countFalse = 0;
        while (requestedAction.hasNext()) {
            boolean contained = false;
            SAMLAction requested = requestedAction.next();
            for (SAMLAction permitted : permittedAction) {
                if (!requested.getNamespace().equals(permitted.getNamespace()) || !requested.getData().equals(permitted.getData())) continue;
                contained = true;
                break;
            }
            if (contained) {
                ++countTrue;
                continue;
            }
            ++countFalse;
        }
        if (countTrue > 0 && countFalse == 0) {
            decision = "Permit";
        } else if (countTrue > 0 && countFalse > 0) {
            decision = "Indeterminate";
        }
        return decision;
    }

    protected abstract List<SAMLAction> getPermittedAction(String var1, Map<String, List<String>> var2, String var3) throws AuthorityException;
}

