/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso.filter;

import info.dragonlady.sso.helper.Authenticator;
import info.dragonlady.sso.message.SSOMessageResource;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class LoginCheckFilter
implements Filter {
    private String paramAuthClass = "auth-class";
    private String paramRedirection = "redirection";
    private String paramIgnore = "ignore";
    private String authClassName = null;
    private String redirectionUrl = null;
    private String[] ignorePath = null;

    public void init(FilterConfig config) throws ServletException {
        this.authClassName = config.getInitParameter(this.paramAuthClass);
        this.redirectionUrl = config.getInitParameter(this.paramRedirection);
        String ignore = config.getInitParameter(this.paramIgnore);
        if (ignore != null && ignore.length() > 0) {
            this.ignorePath = ignore.split(",");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            Authenticator authenticator;
            boolean ignored = false;
            if (this.ignorePath != null && this.ignorePath.length > 0) {
                String targetPath = ((HttpServletRequest)request).getServletPath();
                int i = 0;
                while (i < this.ignorePath.length) {
                    if (this.ignorePath[i].equals(targetPath)) {
                        ignored = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!ignored && !(authenticator = (Authenticator)Class.forName(this.authClassName).newInstance()).authenticate((HttpServletRequest)request)) {
                if (!((HttpServletResponse)response).isCommitted()) {
                    if (this.redirectionUrl != null && this.redirectionUrl.length() > 0) {
                        ((HttpServletResponse)response).sendRedirect(this.redirectionUrl);
                    } else {
                        ((HttpServletResponse)response).sendError(403);
                    }
                }
                return;
            }
            chain.doFilter(request, response);
        }
        catch (IOException e) {
            Logger.getRootLogger().error((Object)SSOMessageResource.getMessage("3001"), (Throwable)e);
            throw e;
        }
        catch (ServletException e) {
            Logger.getRootLogger().error((Object)SSOMessageResource.getMessage("3002"), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Logger.getRootLogger().error((Object)SSOMessageResource.getMessage("3003"), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
    }
}

