/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso.helper;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginManager {
    private static final LoginManager lm = new LoginManager();
    private volatile Map<String, String> userMap = Collections.synchronizedMap(new HashMap());

    private LoginManager() {
    }

    public static final LoginManager getInstance() {
        return lm;
    }

    public synchronized void add(String user, String relationId) {
        if (!this.userMap.containsKey(user)) {
            this.userMap.put(user, relationId);
        }
    }

    public synchronized void remove(String user) {
        this.userMap.remove(user);
    }

    public synchronized void removeById(String relationId) {
        this.userMap.values().remove(relationId);
    }

    public synchronized boolean isLoggedIn(String user) {
        return this.userMap.containsKey(user);
    }

    public synchronized Map<String, String> getMap() {
        return Collections.unmodifiableMap(this.userMap);
    }

    public synchronized void setMap(Map<String, String> map) {
        this.clear();
        this.userMap.putAll(map);
    }

    public synchronized void clear() {
        this.userMap.clear();
    }
}

