/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLAuthorizationDecisionStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionParser {
    private SAMLAssertion assertion = null;
    private SAMLAuthenticationStatement authStatement = null;
    private SAMLAttributeStatement attrStatement = null;
    private SAMLAuthorizationDecisionStatement decisionStatement = null;

    public AssertionParser(SAMLAssertion assertion) {
        if (assertion != null) {
            this.assertion = assertion;
            this.extractStatement(assertion);
        }
    }

    private void extractStatement(SAMLAssertion assertion) {
        Iterator itr = assertion.getStatements();
        while (itr.hasNext()) {
            Object statement = itr.next();
            if (statement instanceof SAMLAuthenticationStatement) {
                this.authStatement = (SAMLAuthenticationStatement)statement;
                continue;
            }
            if (statement instanceof SAMLAttributeStatement) {
                this.attrStatement = (SAMLAttributeStatement)statement;
                continue;
            }
            if (!(statement instanceof SAMLAuthorizationDecisionStatement)) continue;
            this.decisionStatement = (SAMLAuthorizationDecisionStatement)statement;
        }
    }

    public String getName() {
        String name = null;
        if (this.authStatement != null) {
            name = this.authStatement.getSubject().getNameIdentifier().getName();
        } else if (this.attrStatement != null) {
            name = this.attrStatement.getSubject().getNameIdentifier().getName();
        } else if (this.decisionStatement != null) {
            name = this.decisionStatement.getSubject().getNameIdentifier().getName();
        }
        return name;
    }

    public Map<String, List<String>> getAttribute() {
        HashMap attributes = null;
        if (this.attrStatement != null) {
            attributes = new HashMap();
            Iterator itr = this.attrStatement.getAttributes();
            while (itr.hasNext()) {
                SAMLAttribute attribute = (SAMLAttribute)itr.next();
                String name = attribute.getName();
                ArrayList<String> value = new ArrayList<String>();
                Iterator valItr = attribute.getValues();
                while (valItr.hasNext()) {
                    value.add((String)valItr.next());
                }
                attributes.put(name, value);
            }
        }
        return attributes;
    }

    public boolean isPermitted() {
        return this.decisionStatement != null ? this.decisionStatement.getDecision().equals("Permit") : false;
    }

    public Iterator<SAMLAction> getPermittedActions() {
        return this.decisionStatement != null ? this.decisionStatement.getActions() : null;
    }

    public String getResource() {
        return this.decisionStatement != null ? this.decisionStatement.getResource() : null;
    }

    public boolean containsAuthenticationStatement() {
        return this.authStatement != null;
    }

    public boolean containsAttributeStatement() {
        return this.attrStatement != null;
    }

    public boolean containsDecisionStatement() {
        return this.decisionStatement != null;
    }

    public SAMLAttributeStatement getAttributeStatement() {
        return this.attrStatement;
    }

    public SAMLAuthenticationStatement getAuthenticationStatement() {
        return this.authStatement;
    }

    public SAMLAuthorizationDecisionStatement getDecisionStatement() {
        return this.decisionStatement;
    }
}

