/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso.util;

import info.dragonlady.sso.util.ResourceParseException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ResourceUtils {
    public static final String getString(String resourcePath, String expression) throws ResourceParseException {
        try {
            return (String)ResourceUtils.evaluate(resourcePath, expression, XPathConstants.STRING);
        }
        catch (ResourceParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceParseException(e);
        }
    }

    public static final NodeList getNodeSet(String resourcePath, String expression) throws ResourceParseException {
        try {
            return (NodeList)ResourceUtils.evaluate(resourcePath, expression, XPathConstants.NODESET);
        }
        catch (ResourceParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceParseException(e);
        }
    }

    public static final Object evaluate(String resourcePath, String expression, QName returnType) throws ResourceParseException {
        try {
            URL url = ResourceUtils.class.getClassLoader().getResource(resourcePath);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(url.openStream());
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            return xpath.evaluate(expression, dom, returnType);
        }
        catch (Exception e) {
            throw new ResourceParseException(e);
        }
    }

    public static final String toBase64String(byte[] src) {
        return new String(Base64.encodeBase64((byte[])src));
    }

    public static final String toHexString(byte[] src) {
        return new String(Hex.encodeHex((byte[])src));
    }

    public static final byte[] toBase64ByteArray(String src) {
        return Base64.decodeBase64((byte[])src.getBytes());
    }

    public static final byte[] toHexByteArray(String src) throws DecoderException {
        return Hex.decodeHex((char[])src.toCharArray());
    }

    public static final String getTextContent(Node node) {
        String content = null;
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            if (child.getNodeType() == 3) {
                content = ((Text)child).getData();
                break;
            }
            ++i;
        }
        return content;
    }
}

