/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso.helper;

import info.dragonlady.cluster.Friend;
import info.dragonlady.sso.util.ResourceParseException;
import info.dragonlady.sso.util.ResourceUtils;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SSOServletConfig {
    private static final String resourcePath = "resources/sso_lib_config.xml";

    public static final boolean isAuthRequired(String kind) throws ResourceParseException {
        String expression = "sso_lib/auth-settings/auth[@kind='" + kind + "']/@auth-required";
        return Boolean.valueOf(ResourceUtils.getString((String)resourcePath, (String)expression));
    }

    public static final String getAuthClassName(String kind) throws ResourceParseException {
        String expression = "sso_lib/auth-settings/auth[@kind='" + kind + "']/@auth-class";
        return ResourceUtils.getString((String)resourcePath, (String)expression);
    }

    public static final String getAttributesClassName(String kind) throws ResourceParseException {
        String expression = "sso_lib/auth-settings/auth[@kind='" + kind + "']/@attr-class";
        return ResourceUtils.getString((String)resourcePath, (String)expression);
    }

    public static final String getRequestParamLoginKey() throws ResourceParseException {
        String expression = "sso_lib/session-attributes/login-key/@request-param";
        return ResourceUtils.getString((String)resourcePath, (String)expression);
    }

    public static final String getSessionLoginKey() throws ResourceParseException {
        String expression = "sso_lib/session-attributes/login-key";
        return ResourceUtils.getString((String)resourcePath, (String)expression);
    }

    public static final Map getSessionAttributeKeys() throws ResourceParseException {
        String expression = "sso_lib/session-attributes/key";
        NodeList nodeList = ResourceUtils.getNodeSet((String)resourcePath, (String)expression);
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String requestParam = node.getAttributes().getNamedItem("request-param").getNodeValue();
            map.put(requestParam, ResourceUtils.getTextContent((Node)node));
            ++i;
        }
        return map;
    }

    public static final String getRedirection() throws ResourceParseException {
        String expression = "sso_lib/redirection";
        return ResourceUtils.getString((String)resourcePath, (String)expression);
    }

    public static final String getCooperationService() throws ResourceParseException {
        String expression = "sso_lib/cooperation-service";
        return ResourceUtils.getString((String)resourcePath, (String)expression);
    }

    public static final boolean isClusterStandalone() throws ResourceParseException {
        String expression = "sso_lib/cluster/@standalone";
        return Boolean.valueOf(ResourceUtils.getString((String)resourcePath, (String)expression));
    }

    public static final Friend[] getFriends() throws ResourceParseException {
        String expression = "sso_lib/cluster/friends_ip";
        NodeList list = ResourceUtils.getNodeSet((String)resourcePath, (String)expression);
        Friend[] friends = new Friend[list.getLength()];
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            NamedNodeMap paramMap = node.getAttributes();
            String host = paramMap.getNamedItem("host").getNodeValue();
            String port = paramMap.getNamedItem("port").getNodeValue();
            Friend friend = new Friend();
            friend.setHost(host);
            friend.setPort(port);
            friends[i] = friend;
            ++i;
        }
        return friends;
    }

    public static final String getServiceName(String ipAddress, String port, String serviceName) {
        StringBuffer name = new StringBuffer();
        name.append("//");
        name.append(ipAddress);
        name.append(":");
        name.append(port);
        name.append("/");
        name.append(serviceName);
        return name.toString();
    }
}

