/*
 * @(#)CooperationImpl.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.system.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

/**
 * AgVXeT[rXC^[tF[X̎NXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/09/07 21:12:02 $
 */
public class CooperationImpl implements Cooperation {

	/**
	 * RXgN^B
	 */
	public CooperationImpl() {
		super();
	}

	/**
	 * wFIDOC̃T[oA
	 * OCT[õA[eBt@Ng擾B
	 * OC̃T[oȂ΁AnullB
	 * 
	 * @param id FID
	 * @return String A[eBt@Ng
	 * @see info.dragonlady.system.service.Cooperation#getSiteTransferUrl()
	 */
	public String getArtifact(String id) {
		String artifact = null;
		List urlList = ServerUrlManager.getInstance().getList();
		for(int i = 0; i < urlList.size(); i++) {
			String url = (String)urlList.get(i);
			try {
				artifact = inquire(url, id);
				if(artifact != null) {
					break;
				}
			} catch(Exception e) {
				log("failed to inquire. (url:" + url + ")", e);
			}
		}
		return artifact;
	}

	private String inquire(String urlStr, String id) throws IOException {
		String content = null;
		InputStream is = null;
		try {
			URL url = new URL(urlStr + "?id=" + id);
			HttpURLConnection con = (HttpURLConnection)url.openConnection();
			if(con.getResponseCode() == HttpURLConnection.HTTP_OK) {
				is = con.getInputStream();
				byte[] b = new byte[is.available()];
				is.read(b);
				if(b.length > 0) {
					content = new String(b);
				}
			}
			return content;
		} finally {
			if(is != null) {
				try {
					is.close();
				} catch(Exception e) {
				}
			}
		}
	}

	private void log(String message, Exception e) {
		try {
			Logger logger = Logger.getLogger("UserLogger");
			URL url = this.getClass().getClassLoader().getResource("log4j.xml");
			DOMConfigurator.configure(url);
			logger.log(Level.WARN, message, e);
		} catch(Exception ex) {
			ex.printStackTrace();
		}
	}

}
