/*
 * @(#)CooperationImplTest.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.system.service;

import info.dragonlady.system.service.CooperationImpl;
import info.dragonlady.system.service.ServerUrlManager;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

import junit.framework.TestCase;

/**
 * CooperationImpl NXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/12/12 2:13:57 $
 */
public class CooperationImplTest extends TestCase {

	private String id = "00000000000e";

	private String url = "http://localhost:8080/auth/ArtifactResponder";

	/**
	 * @param arg0
	 */
	public CooperationImplTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.system.service.CooperationImpl#CooperationImpl()} ̂߂̃eXgE\bhB
	 */
	public final void testCooperationImpl() {
		try {
			new CooperationImpl();
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.system.service.CooperationImpl#getArtifact(java.lang.String)} ̂߂̃eXgE\bhB
	 */
	public final void testGetArtifact() {
		try {
			login();
			ServerUrlManager.getInstance().add(url);

			CooperationImpl impl = new CooperationImpl();
			String artifact = impl.getArtifact(id);
			assertTrue(artifact != null && artifact.length() > 0);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	private void login() throws IOException {
		String urlStr = "http://localhost:8080/auth/SiteTransfer?TARGET=http%3A%2F%2Flocalhost%3A8080%2Fportal%2Ftop.html&termid=1&parent=parentAttribute&accountid=" + id;
		InputStream is = null;
		try {
			URL url = new URL(urlStr);
			HttpURLConnection con = (HttpURLConnection)url.openConnection();
			is = con.getInputStream();
			byte[] b = new byte[is.available()];
			is.read(b);
		} finally {
			if(is != null) {
				try {
					is.close();
				} catch(Exception e) {
				}
			}
		}
	}

}
