package info.dragonlady.scriptlet.demo;

import java.util.HashMap;
import java.util.Map;

import info.dragonlady.scriptlet.DefaultScriptlet;

public class SequenceControlScriptlet extends DefaultScriptlet {

	private static final long serialVersionUID = -2519140353067643086L;

	private HashMap<String, Object> globalObjMap = new HashMap<String, Object>();
	private String nextSequenceObj = null;

	public void setNextInitSequence(String seqObj) {
		nextSequenceObj = seqObj;
	}

	public String getNextInitSequence() {
		return nextSequenceObj;
	}
	
	public String getInitSequence() {
		return getInitParameter("seqid");
	}

	protected int getDefaultSequence() {
		if(getInitParameter("ignore") !=null && Boolean.parseBoolean(getInitParameter("ignore"))) {
			return INIT_SEQUENCE;
		}
		return INVALID_SEQUENCE;
	}
	
	public Map<String, Object> getScriptNewProperties() {
		globalObjMap.put("scriptlet", this);
		return globalObjMap;
	}
}
