/*
 * @(#)LoginSessionListener.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso.listener;

import info.dragonlady.cluster.UserServiceWrapper;
import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.helper.LoginManager;
import info.dragonlady.sso.message.SSOMessageResource;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

import org.apache.log4j.Logger;


/**
 * OCԊǗp̃Xi[NXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/12/09 16:07:47 $
 */
public class LoginSessionListener implements HttpSessionListener {

	/**
	 * RXgN^B
	 */
	public LoginSessionListener() {
	}

	/**
	 * ZbV쐬ʒmB
	 * 
	 * @param event Cxg
	 * @see javax.servlet.http.HttpSessionListener#sessionCreated(javax.servlet.http.HttpSessionEvent)
	 */
	public void sessionCreated(HttpSessionEvent event) {
		// Ȃ
	}

	/**
	 * ZbVʒmB
	 * 
	 * @param event Cxg
	 * @see javax.servlet.http.HttpSessionListener#sessionDestroyed(javax.servlet.http.HttpSessionEvent)
	 */
	public void sessionDestroyed(HttpSessionEvent event) {
		try {
			HttpSession session = event.getSession();
			if(session != null) {
				String id = (String)session.getAttribute(SSOConfig.getLoginKey());
				if(id != null) {
					LoginManager.getInstance().remove(id);
					// U烍OCԂ폜
					if(!SSOConfig.isClusterStandalone()) {
						UserServiceWrapper.remove(id);
					}
				} else {
					String sessionId = session.getId();
					LoginManager.getInstance().removeById(sessionId);
					// U烍OCԂ폜
					if(!SSOConfig.isClusterStandalone()) {
						UserServiceWrapper.removeByRelationId(sessionId);
					}
				}
			}
		} catch(Exception e) {
			Logger.getRootLogger().error(SSOMessageResource.getMessage("4001"), e);
		}
	}

}
