/*
 * @(#)ResponderServlet.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import info.dragonlady.sso.Responder;
import info.dragonlady.sso.SSOException;
import info.dragonlady.sso.message.SSOMessageResource;

/**
 * SAMLT[ubgB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/10/19 17:40:11 $
 */
public class ResponderServlet extends SSOBaseServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = -9140276146875567412L;

	/**
	 * RXgN^B
	 */
	public ResponderServlet() {
		super();
	}

	/**
	 * SAMLB
	 * 
	 * @param request HTTPvIuWFNg
	 * @param response HTTPIuWFNg
	 * @throws ServletException
	 * @throws IOException
	 * @see info.dragonlady.sso.servlet.SSOBaseServlet#process(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		try {
			// SAMLvɊ܂܂A[eBt@NgɑΉAT[V擾ASAMLɊ܂߂ĉ
			Responder responder = new Responder(request, response);
			responder.processRequest();
		} catch(SSOException e) {
			processException(SSOMessageResource.getMessage("5101"), e, response, HttpServletResponse.SC_FORBIDDEN);
		} catch(Exception e) {
			processException(SSOMessageResource.getMessage("5102"), e, response, HttpServletResponse.SC_NOT_FOUND);
		}
	}

}
