/*
 * @(#)TestPolicyDecisionPoint.java
 *
 * Copyright (C) 2007 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.authority;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.opensaml.SAMLAction;

import info.dragonlady.sso.authority.AuthorityException;
import info.dragonlady.sso.authority.PolicyDecisionPoint;

/**
 * |V[_̃eXgpNXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2007/06/05 19:45:51 $
 */
public class TestPolicyDecisionPoint extends PolicyDecisionPoint {

	private List<SAMLAction> actions = new ArrayList<SAMLAction>();

	public TestPolicyDecisionPoint() {
	}

	public void setActions(List<SAMLAction> actions) {
		this.actions = actions;
	}

	/* (non-Javadoc)
	 * @see info.dragonlady.sso.authority.PolicyDecisionPoint#getPermittedAction(java.lang.String, java.util.Map, java.lang.String)
	 */
	@Override
	protected List<SAMLAction> getPermittedAction(String authId,
			Map<String, List<String>> attributes, String resource)
			throws AuthorityException {
		return actions;
	}

}
