/*
 * @(#)MessageResourceTest.java
 *
 * Copyright (C) 2005 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.message;

import info.dragonlady.sso.message.MessageResource;
import junit.framework.TestCase;

/**
 * MessageResourceNX̃eXgP[X
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.1 $ $Date: 2005/10/31 05:27:19 $
 */
public class MessageResourceTest extends TestCase {

	/**
	 * Constructor for MessageResourceTest.
	 * @param arg0
	 */
	public MessageResourceTest(String arg0) {
		super(arg0);
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/*
	 * Test method for 'jp.co.infocity.transform.message.MessageResource.MessageResource(String)'
	 */
	public final void testMessageResource() {
		try {
			String resourceName = "resources.sso_message";
			new MessageResource(resourceName);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/*
	 * Test method for 'jp.co.infocity.transform.message.MessageResource.getMessage(String)'
	 */
	public final void testGetMessageString() {
		try {
			String resourceName = "resources.sso_message";
			String key = "1004";
			String expected = "SAMLւ̃AT[VǉɃG[܂B";

			MessageResource mr = new MessageResource(resourceName);
			String result = mr.getMessage(key);
			assertTrue(expected.equals(result));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/*
	 * Test method for 'jp.co.infocity.transform.message.MessageResource.getMessage(String, Object[])'
	 */
	public final void testGetMessageStringObjectArray() {
		try {
			String resourceName = "resources.sso_message";
			String key = "1003";
			Object[] args = {"param1"};
			String expected = "A[eBt@NgɑΉAT[V܂łBartifact:param1";

			MessageResource mr = new MessageResource(resourceName);
			String result = mr.getMessage(key, args);
			assertTrue(expected.equals(result));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
