/*
 * @(#)SSOConfig.java
 *
 * Copyright (C) 2005 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso;

import info.dragonlady.sso.util.ResourceParseException;
import info.dragonlady.sso.util.ResourceUtils;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.NodeList;


/**
 * VOTCI@\Ŏgpݒ胊\[XANZXNX
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.2 $ $Date: 2005/11/15 18:12:24 $
 */
public class SSOConfig {

	/**
	 * \[XpX
	 */
	private static final String resourcePath = "resources/sso_config.xml";

	/**
	 * voC_擾
	 * \[XIDɎgp
	 * 
	 * @return String voC_
	 * @throws ResourceParseException
	 */
	public static final String getProvider() throws ResourceParseException {
		String expression = "sso/provider";
		return ResourceUtils.getString(SSOConfig.resourcePath, expression);
	}

	/**
	 * AT[Vs擾
	 * 
	 * @return String AT[Vs
	 * @throws ResourceParseException
	 */
	public static final String getIssuer() throws ResourceParseException {
		String expression = "sso/issuer";
		return ResourceUtils.getString(SSOConfig.resourcePath, expression);
	}

	/**
	 * SAMLAT[VɊ܂߂鑮̃Xg擾
	 * 
	 * @return List AT[VɊ܂߂鑮̃Xg
	 * @throws ResourceParseException
	 */
	public static final List getSAMLAttributeList() throws ResourceParseException {
		String expression = "sso/saml_attribute/name";
		NodeList nodeList = ResourceUtils.getNodeSet(SSOConfig.resourcePath, expression);
		List list = new ArrayList();
		for(int i = 0; i < nodeList.getLength(); i++) {
			list.add(ResourceUtils.getTextContent(nodeList.item(i)));
		}
		return list;
	}

	/**
	 * AT[VLibj擾
	 * 
	 * @return Integer AT[VLibj
	 * @throws ResourceParseException
	 */
	public static final Integer getAssertionLife() throws ResourceParseException {
		String expression = "sso/assertion_life";
		return new Integer(ResourceUtils.getString(SSOConfig.resourcePath, expression));
	}

	/**
	 * F؃I[\eBNX擾B
	 * 
	 * @return String F؃I[\eBNX
	 * @throws ResourceParseException
	 */
	public static final String getAuthenticationAuthorityClass() throws ResourceParseException {
		String expression = "sso/authority/authentication-class";
		return ResourceUtils.getString(SSOConfig.resourcePath, expression);
	}

	/**
	 * I[\eBNX擾B
	 * 
	 * @return String I[\eBNX
	 * @throws ResourceParseException
	 */
	public static final String getAttributeAuthorityClass() throws ResourceParseException {
		String expression = "sso/authority/attribute-class";
		return ResourceUtils.getString(SSOConfig.resourcePath, expression);
	}

	/**
	 * |V[_NX擾B
	 * 
	 * @return String |V[_NX
	 * @throws ResourceParseException
	 */
	public static final String getPolicyDecisionPointClass() throws ResourceParseException {
		String expression = "sso/authority/policy-decision-class";
		return ResourceUtils.getString(SSOConfig.resourcePath, expression);
	}

	/**
	 * |V[s_NX擾B
	 * 
	 * @return String |V[s_NX
	 * @throws ResourceParseException
	 */
	public static final String getPolicyEnforcementPointClass() throws ResourceParseException {
		String expression = "sso/policy-enforcement-class";
		return ResourceUtils.getString(SSOConfig.resourcePath, expression);
	}

	/**
	 * IDǗNX擾B
	 * 
	 * @return String IDǗNX
	 * @throws ResourceParseException
	 */
	public static final String getIDProviderClass() throws ResourceParseException {
		String expression = "sso/idprovider-class";
		return ResourceUtils.getString(SSOConfig.resourcePath, expression);
	}

}
