/*
 * @(#)AllTests.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso;

import test.info.dragonlady.sso.message.MessageResourceTest;
import test.info.dragonlady.sso.message.SSOMessageResourceTest;
import test.info.dragonlady.sso.util.ResourceParseExceptionTest;
import test.info.dragonlady.sso.util.ResourceUtilsTest;
import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * SeXgP[XsNX
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/10/24 18:22:43 $
 */
public class AllTests {

	public static void main(String[] args) {
		junit.textui.TestRunner.run(AllTests.suite());
		junit.textui.TestRunner.run(AllTests.suite2());
		junit.textui.TestRunner.run(AllTests.suite3());
	}

	public static Test suite() {
		TestSuite suite = new TestSuite("Test for test.info.dragonlady.sso");
		//$JUnit-BEGIN$
		suite.addTestSuite(RequesterTest.class);
		suite.addTestSuite(ArtifactReceiverTest.class);
		suite.addTestSuite(ResponderTest.class);
		suite.addTestSuite(ResponderResourceTest.class);
		suite.addTestSuite(SSOExceptionTest.class);
		suite.addTestSuite(SiteTransferTest.class);
		suite.addTestSuite(SSOConfigTest.class);
		suite.addTestSuite(ReceiverResourceTest.class);
		suite.addTestSuite(AssertionNotFoundExceptionTest.class);
		suite.addTestSuite(AssertionManagerTest.class);
		suite.addTestSuite(RequestFailedExceptionTest.class);
		//$JUnit-END$
		return suite;
	}

	public static Test suite2() {
		TestSuite suite = new TestSuite("Test for test.info.dragonlady.sso.message");
		//$JUnit-BEGIN$
		suite.addTestSuite(MessageResourceTest.class);
		suite.addTestSuite(SSOMessageResourceTest.class);
		//$JUnit-END$
		return suite;
	}

	public static Test suite3() {
		TestSuite suite = new TestSuite("Test for test.info.dragonlady.sso.util");
		//$JUnit-BEGIN$
		suite.addTestSuite(ResourceParseExceptionTest.class);
		suite.addTestSuite(ResourceUtilsTest.class);
		//$JUnit-END$
		return suite;
	}

}
